/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.CHTags;
import com.ffsupver.createheat.block.thermalBlock.BaseThermalBlock;
import com.ffsupver.createheat.block.thermalBlock.CopycatThermalBlockEntity;
import com.ffsupver.createheat.block.thermalBlock.CopycatThermalBlockModel;
import com.ffsupver.createheat.registries.CHBlocks;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.Nullable;

public class CopycatThermalBlock
extends BaseThermalBlock<CopycatThermalBlockEntity> {
    public CopycatThermalBlock(BlockBehaviour.Properties properties) {
        super(properties, CopycatThermalBlockEntity.class, () -> (BlockEntityType)CHBlocks.COPYCAT_THERMAL_BLOCK_ENTITY.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canConnectTextures(BlockState state) {
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        AtomicReference<ItemStack> stack = new AtomicReference<ItemStack>(ItemStack.EMPTY);
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), copycatThermalBlockEntity -> stack.set(copycatThermalBlockEntity.removeMaterial()));
        if (stack.get().isEmpty()) {
            return super.onWrenched(state, context);
        }
        ItemStack returnItem = stack.get();
        Player player = context.getPlayer();
        if (player != null && !player.isCreative()) {
            player.getInventory().placeItemBackInInventory(returnItem);
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockState material;
        if (player == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.isEmpty() && player.isShiftKeyDown() && this.cycleStateProperty(level, pos, material = CopycatThermalBlock.getMaterial((BlockGetter)level, pos))) {
            return ItemInteractionResult.SUCCESS;
        }
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockItem bi = (BlockItem)item;
        Block block = bi.getBlock();
        BlockState material2 = block.defaultBlockState();
        if (material2.is(CHTags.BlockTag.COPYCAT_THERMAL_BLOCK_DENY) || !material2.isCollisionShapeFullBlock((BlockGetter)level, pos) || !material2.canOcclude() || !material2.getRenderShape().equals((Object)RenderShape.MODEL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (material2.hasProperty((Property)CommandBlock.FACING)) {
            material2 = (BlockState)material2.setValue((Property)CommandBlock.FACING, (Comparable)player.getNearestViewDirection().getOpposite());
        }
        if (material2.hasProperty((Property)BlockStateProperties.AXIS)) {
            material2 = (BlockState)material2.setValue((Property)BlockStateProperties.AXIS, (Comparable)player.getNearestViewDirection().getAxis());
        }
        AtomicBoolean set = new AtomicBoolean(false);
        BlockState finalMaterial = material2;
        this.withBlockEntityDo((BlockGetter)level, pos, copycatThermalBlockEntity -> set.set(copycatThermalBlockEntity.setMaterial(finalMaterial, stack)));
        if (set.get()) {
            if (!player.isCreative()) {
                stack.shrink(1);
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, ItemStack.EMPTY);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        InteractionResult result = super.useWithoutItem(state, level, pos, player, hitResult);
        if (!(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof WrenchItem) && result.equals((Object)InteractionResult.PASS)) {
            return this.executeWithMaterial(state, (BlockGetter)level, pos, (m, s, l, p) -> m.useWithoutItem((Level)l, player, hitResult), () -> result);
        }
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        ModelData modelData = level.getModelData(pos);
        if (modelData == ModelData.EMPTY) {
            return CopycatThermalBlock.getMaterial((BlockGetter)level, pos);
        }
        BlockState fromModel = CopycatThermalBlockModel.getMaterial(modelData);
        return fromModel == null ? state : fromModel;
    }

    public static BlockState getMaterial(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CopycatThermalBlockEntity) {
            CopycatThermalBlockEntity copycatThermalBlockEntity = (CopycatThermalBlockEntity)blockEntity;
            return copycatThermalBlockEntity.getMaterial();
        }
        return CHBlocks.COPYCAT_THERMAL_BLOCK.getDefaultState();
    }

    private boolean cycleStateProperty(Level level, BlockPos pos, BlockState material) {
        boolean hasLit = material.hasProperty((Property)BlockStateProperties.LIT);
        boolean hasPowered = material.hasProperty((Property)BlockStateProperties.POWERED);
        boolean hasPowering = material.hasProperty((Property)RoseQuartzLampBlock.POWERING);
        BlockState newMaterial = material;
        if (hasLit) {
            newMaterial = (BlockState)newMaterial.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf((Boolean)newMaterial.getValue((Property)BlockStateProperties.LIT) == false));
        }
        if (hasPowered && (!hasLit || hasLit && ((Boolean)newMaterial.getValue((Property)BlockStateProperties.LIT)).booleanValue())) {
            newMaterial = (BlockState)newMaterial.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf((Boolean)newMaterial.getValue((Property)BlockStateProperties.POWERED) == false));
        }
        if (hasPowering) {
            newMaterial = (BlockState)newMaterial.setValue((Property)RoseQuartzLampBlock.POWERING, (Comparable)Boolean.valueOf((Boolean)newMaterial.getValue((Property)RoseQuartzLampBlock.POWERING) == false));
        }
        if (!newMaterial.equals(material)) {
            BlockState finalMaterial = newMaterial;
            this.withBlockEntityDo((BlockGetter)level, pos, copycatThermalBlockEntity -> copycatThermalBlockEntity.forceSetMaterial(finalMaterial));
            return true;
        }
        return false;
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        AuxiliaryLightManager lightManager = level.getAuxLightManager(pos);
        if (lightManager != null) {
            return lightManager.getLightAt(pos);
        }
        return super.getLightEmission(state, level, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor wrappedColor() {
        return new WrappedBlockColor();
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.executeWithMaterial(state, level, pos, (m, s, l, p) -> Float.valueOf(m.getExplosionResistance(l, p, explosion)), () -> Float.valueOf(super.getExplosionResistance(state, level, pos, explosion))).floatValue();
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return this.executeWithMaterial(state1, (BlockGetter)level, pos, (m, s, l, p) -> m.addLandingEffects((ServerLevel)l, p, state2, entity, numberOfParticles), () -> super.addLandingEffects(state1, level, pos, state2, entity, numberOfParticles));
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        return this.executeWithMaterial(state, (BlockGetter)level, pos, (m, s, l, p) -> m.addRunningEffects((Level)l, p, entity), () -> super.addRunningEffects(state, level, pos, entity));
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return this.executeWithMaterial(state, (BlockGetter)level, pos, (m, s, l, p) -> Float.valueOf(m.getEnchantPowerBonus((LevelReader)l, p)), () -> Float.valueOf(super.getEnchantPowerBonus(state, level, pos))).floatValue();
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return this.executeWithMaterial(state, level, pos, (m, s, l, p) -> m.canEntityDestroy(l, p, entity), () -> super.canEntityDestroy(state, level, pos, entity));
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        this.executeWithMaterial(state, (BlockGetter)level, pos, (material, s, l, p) -> {
            material.getBlock().fallOn((Level)l, s, p, entity, fallDistance);
            return null;
        }, () -> {
            super.fallOn(level, state, pos, entity, fallDistance);
            return null;
        });
    }

    @Override
    public boolean isBurning(BlockState state, BlockGetter level, BlockPos pos) {
        return this.executeWithMaterial(state, level, pos, (material, s, l, p) -> {
            if (material.is(CHTags.BlockTag.HEAT_ENTITY_ABOVE)) {
                return super.isBurning(state, level, pos);
            }
            return material.getBlock().isBurning(s, l, p);
        }, () -> super.isBurning(state, level, pos));
    }

    @Override
    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (state.is(CHTags.BlockTag.HEAT_ENTITY_ABOVE)) {
            super.stepOn(level, pos, state, entity);
        } else {
            this.executeWithMaterial(state, (BlockGetter)level, pos, (material, s, l, p) -> {
                if (material.is(CHTags.BlockTag.HEAT_ENTITY_ABOVE)) {
                    super.stepOn(level, pos, state, entity);
                } else {
                    material.getBlock().stepOn((Level)l, p, s, entity);
                }
                return null;
            }, () -> {
                super.stepOn(level, pos, state, entity);
                return null;
            });
        }
    }

    private <T> T executeWithMaterial(BlockState state, BlockGetter level, BlockPos pos, MaterialFunction<T> materialFunction, Supplier<T> fallback) {
        BlockState material = CopycatThermalBlock.getMaterial(level, pos);
        if (material != null && !(material.getBlock() instanceof CopycatThermalBlock)) {
            return materialFunction.apply(material, state, level, pos);
        }
        return fallback.get();
    }

    @FunctionalInterface
    private static interface MaterialFunction<T> {
        public T apply(BlockState var1, BlockState var2, BlockGetter var3, BlockPos var4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedBlockColor
    implements BlockColor {
        public int getColor(BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
            if (pLevel == null || pPos == null) {
                return GrassColor.get((double)0.5, (double)1.0);
            }
            BlockState material = CopycatThermalBlock.getMaterial((BlockGetter)pLevel, pPos);
            if (material.getBlock() instanceof CopycatThermalBlock) {
                return 0xFFFFFF;
            }
            return Minecraft.getInstance().getBlockColors().getColor(CopycatThermalBlock.getMaterial((BlockGetter)pLevel, pPos), pLevel, pPos, pTintIndex);
        }
    }
}

