/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.block.thermalBlock.BaseThermalBlockEntity;
import com.ffsupver.createheat.registries.CHBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;

public class CopycatThermalBlockEntity
extends BaseThermalBlockEntity {
    private BlockState cashedState;
    private BlockState cashedMaterial;
    private BlockState material = CHBlocks.COPYCAT_THERMAL_BLOCK.getDefaultState();
    private ItemStack itemStack = ItemStack.EMPTY;

    public CopycatThermalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ModelData getModelData() {
        return ModelData.builder().with(CopycatModel.MATERIAL_PROPERTY, (Object)this.getMaterial()).build();
    }

    public boolean hasMaterial() {
        return !this.material.is(CHBlocks.COPYCAT_THERMAL_BLOCK);
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        BlockState preMaterial = this.material;
        this.material = NbtUtils.readBlockState((HolderGetter)this.blockHolderGetter(), (CompoundTag)tag.getCompound("Material"));
        this.itemStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("item"));
        if (clientPacket && preMaterial != this.material) {
            this.redraw();
        }
    }

    @Override
    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("Material", (Tag)NbtUtils.writeBlockState((BlockState)this.material));
        tag.put("item", this.itemStack.saveOptional(registries));
    }

    public void tick() {
        super.tick();
        if (!this.getBlockState().equals(this.cashedState)) {
            this.cashedState = this.getBlockState();
            this.updateLight();
        }
        if (!this.material.equals(this.cashedMaterial)) {
            this.cashedMaterial = this.material;
            this.redraw();
        }
    }

    public boolean setMaterial(BlockState material, ItemStack stack) {
        if (!this.hasMaterial() && !material.is((Block)CHBlocks.COPYCAT_THERMAL_BLOCK.get())) {
            this.forceSetMaterial(material, stack);
            return true;
        }
        return false;
    }

    public void forceSetMaterial(BlockState material) {
        this.material = material;
    }

    public void forceSetMaterial(BlockState material, ItemStack stack) {
        this.material = material;
        this.itemStack = stack.copyWithCount(1);
    }

    public ItemStack removeMaterial() {
        if (this.hasMaterial()) {
            this.material = CHBlocks.COPYCAT_THERMAL_BLOCK.getDefaultState();
            ItemStack result = this.itemStack;
            this.itemStack = ItemStack.EMPTY;
            return result;
        }
        return ItemStack.EMPTY;
    }

    public BlockState getMaterial() {
        return this.material;
    }

    public void notifyUpdate() {
        this.redraw();
        super.notifyUpdate();
    }

    private void redraw() {
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
        if (this.level != null) {
            this.updateLight();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
        }
    }

    private void updateLight() {
        AuxiliaryLightManager lightManager;
        if (this.level != null && (lightManager = this.level.getAuxLightManager(this.getBlockPos())) != null) {
            int blockLight = this.material.is(CHBlocks.COPYCAT_THERMAL_BLOCK) ? 1 : this.material.getLightEmission((BlockGetter)this.level, this.getBlockPos());
            int workLight = switch ((BlazeBurnerBlock.HeatLevel)this.getBlockState().getValue((Property)BlazeBurnerBlock.HEAT_LEVEL)) {
                default -> throw new MatchException(null, null);
                case BlazeBurnerBlock.HeatLevel.NONE -> 0;
                case BlazeBurnerBlock.HeatLevel.SMOULDERING, BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> 4;
                case BlazeBurnerBlock.HeatLevel.SEETHING -> 8;
            };
            int r = Math.min(15, blockLight + workLight);
            lightManager.setLightAt(this.getBlockPos(), r);
        }
    }

    @Override
    public void destroy() {
        Vec3 itemDropPos = this.getBlockPos().getCenter();
        if (!this.itemStack.isEmpty() && this.getLevel() != null) {
            Containers.dropItemStack((Level)this.getLevel(), (double)itemDropPos.x(), (double)itemDropPos.y(), (double)itemDropPos.z(), (ItemStack)this.itemStack);
        }
        super.destroy();
    }
}

