/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.block.thermalBlock.CopycatThermalBlock;
import com.ffsupver.createheat.registries.CHBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.content.decoration.copycat.FilteredBlockAndTintGetter;
import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class CopycatThermalBlockModel
extends BakedModelWrapperWithData {
    private static final ModelProperty<OcclusionData> OCCLUSION_PROPERTY = new ModelProperty();
    private static final ModelProperty<ModelData> WRAPPED_DATA_PROPERTY = new ModelProperty();

    public CopycatThermalBlockModel(BakedModel originalModel) {
        super(originalModel);
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        BlockState material = CopycatThermalBlockModel.getMaterial(blockEntityData);
        if (material == null) {
            return builder;
        }
        builder.with(CopycatModel.MATERIAL_PROPERTY, (Object)material);
        Block block = state.getBlock();
        if (!(block instanceof CopycatThermalBlock)) {
            return builder;
        }
        CopycatThermalBlock block2 = (CopycatThermalBlock)block;
        OcclusionData occlusionData = new OcclusionData();
        this.gatherOcclusionData(world, pos, state, material, occlusionData);
        builder.with(OCCLUSION_PROPERTY, (Object)occlusionData);
        ModelData wrappedData = CopycatModel.getModelOf((BlockState)material).getModelData((BlockAndTintGetter)new FilteredBlockAndTintGetter(world, targetPos -> block2.canConnectTextures(state)), pos, material, ModelData.EMPTY);
        return builder.with(WRAPPED_DATA_PROPERTY, (Object)wrappedData);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand) {
        return this.getCroppedQuads(state, side, rand, CopycatThermalBlockModel.getMaterial(ModelData.EMPTY), ModelData.EMPTY, RenderType.solid());
    }

    private List<BakedQuad> getCroppedQuads(BlockState state, Direction side, RandomSource rand, BlockState material, ModelData wrappedData, RenderType renderType) {
        BakedModel model = CopycatModel.getModelOf((BlockState)material);
        return model.getQuads(material, side, rand, wrappedData, renderType);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        BlockState material = CopycatThermalBlockModel.getMaterial(extraData);
        if (material == null) {
            return super.getQuads(state, side, rand, extraData, renderType);
        }
        OcclusionData occlusionData = (OcclusionData)extraData.get(OCCLUSION_PROPERTY);
        if (occlusionData != null && occlusionData.isOccluded(side)) {
            return super.getQuads(state, side, rand, extraData, renderType);
        }
        ModelData wrappedData = (ModelData)extraData.get(WRAPPED_DATA_PROPERTY);
        if (wrappedData == null) {
            wrappedData = ModelData.EMPTY;
        }
        if (renderType != null && !Minecraft.getInstance().getBlockRenderer().getBlockModel(material).getRenderTypes(material, rand, wrappedData).contains(renderType)) {
            return super.getQuads(state, side, rand, extraData, renderType);
        }
        List<BakedQuad> croppedQuads = this.getCroppedQuads(state, side, rand, material, wrappedData, renderType);
        return croppedQuads;
    }

    private void gatherOcclusionData(BlockAndTintGetter world, BlockPos pos, BlockState state, BlockState material, OcclusionData occlusionData) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction face : Iterate.directions) {
            BlockPos.MutableBlockPos neighbourPos = mutablePos.setWithOffset((Vec3i)pos, face);
            BlockState neighbourState = world.getBlockState((BlockPos)neighbourPos);
            if (state.supportsExternalFaceHiding() && neighbourState.hidesNeighborFace((BlockGetter)world, (BlockPos)neighbourPos, state, face.getOpposite())) {
                occlusionData.occlude(face);
                continue;
            }
            if (Block.shouldRenderFace((BlockState)material, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)neighbourPos)) continue;
            occlusionData.occlude(face);
        }
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        BlockState material = CopycatThermalBlockModel.getMaterial(data);
        if (material == null) {
            return super.getParticleIcon(data);
        }
        ModelData wrappedData = (ModelData)data.get(WRAPPED_DATA_PROPERTY);
        if (wrappedData == null) {
            wrappedData = ModelData.EMPTY;
        }
        return CopycatModel.getModelOf((BlockState)material).getParticleIcon(wrappedData);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        BlockState material = CopycatThermalBlockModel.getMaterial(data);
        if (material != null) {
            return Minecraft.getInstance().getBlockRenderer().getBlockModel(material).getRenderTypes(material, rand, data);
        }
        return super.getRenderTypes(state, rand, data);
    }

    public static BlockState getMaterial(ModelData data) {
        BlockState material;
        BlockState blockState = material = data == null ? null : (BlockState)data.get(CopycatModel.MATERIAL_PROPERTY);
        return material == null ? null : (material.is((Block)CHBlocks.COPYCAT_THERMAL_BLOCK.get()) ? null : material);
    }

    private static class OcclusionData {
        private final boolean[] occluded = new boolean[6];

        public void occlude(Direction face) {
            this.occluded[face.get3DDataValue()] = true;
        }

        public boolean isOccluded(Direction face) {
            return face == null ? false : this.occluded[face.get3DDataValue()];
        }
    }
}

