/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import net.minecraft.nbt.CompoundTag;

public class HeatStorage {
    private int capacity;
    private int amount;

    public HeatStorage(int capacity) {
        this.capacity = capacity;
        this.amount = 0;
    }

    public int insert(int heat) {
        int max = this.amount + heat;
        if (max > this.capacity) {
            this.amount = this.capacity;
            return heat - (max - this.capacity);
        }
        this.amount = max;
        return heat;
    }

    public int extract(int heat, boolean simulate) {
        int min = this.amount - heat;
        if (min < 0) {
            if (!simulate) {
                this.amount = 0;
            }
            return heat + min;
        }
        if (!simulate) {
            this.amount = min;
        }
        return heat;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        this.amount = Math.min(this.amount, capacity);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("capacity", this.capacity);
        nbt.putInt("amount", this.amount);
        return nbt;
    }

    public void fromNbt(CompoundTag nbt) {
        this.capacity = nbt.getInt("capacity");
        this.amount = nbt.getInt("amount");
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public String toString() {
        return "{" + this.amount + "/" + this.capacity + "}";
    }
}

