/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.block.thermalBlock.BaseThermalBlock;
import com.ffsupver.createheat.block.thermalBlock.SmartThermalBlockEntity;
import com.ffsupver.createheat.block.thermalBlock.ThermalBlock;
import com.ffsupver.createheat.registries.CHBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SmartThermalBlock
extends BaseThermalBlock<SmartThermalBlockEntity>
implements IWrenchable {
    public SmartThermalBlock(BlockBehaviour.Properties properties) {
        super(properties, SmartThermalBlockEntity.class, () -> (BlockEntityType)CHBlocks.SMART_THERMAL_BLOCK_ENTITY.get());
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return switch ((BlazeBurnerBlock.HeatLevel)state.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL)) {
            default -> throw new MatchException(null, null);
            case BlazeBurnerBlock.HeatLevel.NONE -> 0;
            case BlazeBurnerBlock.HeatLevel.SMOULDERING, BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> 13;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> 10;
        };
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        ThermalBlock.addParticles(state, level, pos, random);
    }

    @Override
    public boolean isBurning(BlockState state, BlockGetter level, BlockPos pos) {
        SmartThermalBlockEntity smartThermalBlock = (SmartThermalBlockEntity)this.getBlockEntity(level, pos);
        return smartThermalBlock != null && smartThermalBlock.isBurning() && super.isBurning(state, level, pos);
    }
}

