/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.tightCompressStone;

import com.ffsupver.createheat.block.thermalBlock.HeatStorage;
import com.ffsupver.createheat.block.thermalBlock.ThermalBlockEntityBehaviour;
import com.ffsupver.createheat.block.tightCompressStone.TightCompressStone;
import com.ffsupver.createheat.registries.CHBlocks;
import com.ffsupver.createheat.util.BlockUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class StoneHeatStorage
extends HeatStorage {
    private static final Supplier<Integer> HEAT_PER_LAVA = () -> ThermalBlockEntityBehaviour.MAX_HEAT.get() * 50;
    public final HashSet<BlockPos> stonePosSet;
    private BlockCounts lastBlockCounts = new BlockCounts();
    private int superHeatCount;

    public StoneHeatStorage(HashSet<BlockPos> stonePosSet) {
        super(StoneHeatStorage.calculateCapacity(stonePosSet));
        this.stonePosSet = stonePosSet;
    }

    public void checkSize(Level level, Set<BlockPos> newBlockPosSet, boolean shouldSetAmountWithoutCheck) {
        int amountFromBlock;
        Set<BlockPos> oldSet = Set.copyOf(this.stonePosSet);
        this.stonePosSet.clear();
        AtomicInteger regularHeatCount = new AtomicInteger();
        AtomicInteger stoneCount = new AtomicInteger();
        AtomicInteger superHeatCount = new AtomicInteger();
        newBlockPosSet.forEach(b -> {
            BlockState bsT = level.getBlockState(b);
            if (StoneHeatStorage.isAvailableRegularHeatBlock(bsT)) {
                regularHeatCount.getAndIncrement();
            } else if (StoneHeatStorage.isAvailableSuperHeatBlock(bsT)) {
                superHeatCount.getAndIncrement();
            } else if (StoneHeatStorage.isAvailableTStoneBlock(bsT)) {
                stoneCount.getAndIncrement();
            }
            this.stonePosSet.add((BlockPos)b);
        });
        if (oldSet.size() != this.stonePosSet.size()) {
            this.setCapacity(StoneHeatStorage.calculateCapacity(this.stonePosSet));
        }
        int lC = regularHeatCount.get();
        int sHC = superHeatCount.get();
        int sC = stoneCount.get();
        int n = amountFromBlock = sC + lC + sHC > 0 ? (lC + sHC) * this.getCapacity() / (sC + lC + sHC) : 0;
        if (shouldSetAmountWithoutCheck) {
            this.setAmount(amountFromBlock);
        } else if (!this.lastBlockCounts.unInit() && this.lastBlockCounts.regular + this.lastBlockCounts.superHeat < lC + sHC) {
            this.setAmount(Math.max(this.getAmount(), amountFromBlock));
        }
        this.lastBlockCounts = new BlockCounts(sC, lC, sHC);
    }

    public boolean checkSize(Level level, Set<BlockPos> newBlockPosSet) {
        if (!this.stonePosSet.isEmpty()) {
            int oldSize = this.stonePosSet.size();
            this.checkSize(level, newBlockPosSet, false);
            return this.stonePosSet.size() != oldSize;
        }
        return false;
    }

    public boolean updateBlockState(Level level) {
        boolean removeTStone;
        if (this.getCapacity() == 0) {
            return false;
        }
        int regularHeatCount = 0;
        int superHeatCount = 0;
        int stoneCount = 0;
        HashSet<BlockPos> stoneBlockPosSet = new HashSet<BlockPos>();
        HashSet<BlockPos> regularHeatBlockPosSet = new HashSet<BlockPos>();
        HashSet<BlockPos> superHeatBlockPosSet = new HashSet<BlockPos>();
        for (BlockPos sPos : this.stonePosSet) {
            if (StoneHeatStorage.isAvailableRegularHeatBlock(level.getBlockState(sPos))) {
                ++regularHeatCount;
                regularHeatBlockPosSet.add(sPos);
                continue;
            }
            if (StoneHeatStorage.isAvailableSuperHeatBlock(level.getBlockState(sPos))) {
                ++superHeatCount;
                superHeatBlockPosSet.add(sPos);
                continue;
            }
            if (!level.getBlockState(sPos).is(CHBlocks.TIGHT_COMPRESSED_STONE)) continue;
            ++stoneCount;
            stoneBlockPosSet.add(sPos);
        }
        if (regularHeatCount + stoneCount == 0) {
            return false;
        }
        int bCount = stoneCount + regularHeatCount + superHeatCount;
        int heatCount = regularHeatCount + superHeatCount;
        int aUp = this.getCapacity() * (heatCount + 1) / bCount;
        int aDw = this.getCapacity() * heatCount / bCount;
        boolean addTStone = aDw > this.getAmount();
        boolean bl = removeTStone = aUp <= this.getAmount();
        if (addTStone) {
            int countToAdd;
            int leftToAdd = countToAdd = (aDw - this.getAmount()) * bCount / this.getCapacity() + 1;
            ArrayList regularHeatPosList = new ArrayList(regularHeatBlockPosSet);
            for (int i = 0; i < Math.min(countToAdd, regularHeatPosList.size()); ++i) {
                BlockPos regularHeatPos = (BlockPos)regularHeatPosList.get(i);
                StoneHeatStorage.setNoneHeatBlock(level, regularHeatPos);
                regularHeatBlockPosSet.remove(regularHeatPos);
                --leftToAdd;
            }
            if (leftToAdd > 0) {
                ArrayList superHeatPosList = new ArrayList(superHeatBlockPosSet);
                for (int i = 0; i < Math.min(leftToAdd, superHeatPosList.size()); ++i) {
                    BlockPos superHeatPos = (BlockPos)superHeatPosList.get(i);
                    StoneHeatStorage.setNoneHeatBlock(level, superHeatPos);
                    superHeatBlockPosSet.remove(superHeatPos);
                }
            }
        } else if (removeTStone) {
            int countToRemove = (this.getAmount() - aUp) * bCount / this.getCapacity() + 1;
            ArrayList stonePosList = new ArrayList(stoneBlockPosSet);
            for (int i = 0; i < Math.min(countToRemove, stonePosList.size()); ++i) {
                BlockPos newRegularPos = (BlockPos)stonePosList.get(i);
                StoneHeatStorage.setRegularHeatBlock(level, newRegularPos);
                regularHeatBlockPosSet.add(newRegularPos);
            }
        }
        superHeatCount = superHeatBlockPosSet.size();
        boolean canAddSuperHeat = this.canSuperHeat();
        boolean shouldAddSuperHeat = this.getSuperHeatCount() > superHeatCount;
        boolean shouldRemoveSuperHeat = this.getSuperHeatCount() < superHeatCount;
        boolean changedSuperHeat = false;
        if (canAddSuperHeat && shouldAddSuperHeat) {
            int leftToAdd = this.getSuperHeatCount() - superHeatCount;
            ArrayList regularHeatPosList = new ArrayList(regularHeatBlockPosSet);
            for (int i = 0; i < Math.min(leftToAdd, regularHeatPosList.size()); ++i) {
                BlockPos superHeatToAdd = (BlockPos)regularHeatPosList.get(i);
                StoneHeatStorage.setSuperHeatBlock(level, superHeatToAdd);
                superHeatBlockPosSet.add(superHeatToAdd);
                changedSuperHeat = true;
            }
        } else if (!canAddSuperHeat || shouldRemoveSuperHeat) {
            int leftToRemove = canAddSuperHeat ? superHeatCount - this.getSuperHeatCount() : superHeatCount;
            ArrayList superHeatPosList = new ArrayList(superHeatBlockPosSet);
            for (int i = 0; i < Math.min(leftToRemove, superHeatPosList.size()); ++i) {
                BlockPos superHeatToRemove = (BlockPos)superHeatPosList.get(i);
                StoneHeatStorage.setRegularHeatBlock(level, superHeatToRemove);
                superHeatBlockPosSet.remove(superHeatToRemove);
                changedSuperHeat = true;
            }
        }
        this.setSuperHeatCount(superHeatBlockPosSet.size());
        return addTStone || removeTStone || changedSuperHeat;
    }

    private boolean canSuperHeat() {
        return this.getAmount() * 2 > this.getCapacity();
    }

    public int getSuperHeatCount() {
        return this.superHeatCount;
    }

    public int getMaxSuperHeatCount() {
        if (!this.canSuperHeat()) {
            return 0;
        }
        return this.lastBlockCounts.unInit() ? this.getAmount() * this.stonePosSet.size() / this.getCapacity() : (this.lastBlockCounts.regular + this.lastBlockCounts.superHeat) / 2;
    }

    public void setSuperHeatCount(int superHeatCount) {
        this.superHeatCount = Math.min(this.getMaxSuperHeatCount(), superHeatCount);
    }

    public static boolean isAvailableBlock(BlockState bsT) {
        return StoneHeatStorage.isAvailableRegularHeatBlock(bsT) || StoneHeatStorage.isAvailableTStoneBlock(bsT) || StoneHeatStorage.isAvailableSuperHeatBlock(bsT);
    }

    public static boolean isAvailableRegularHeatBlock(BlockState bsT) {
        return bsT.is(CHBlocks.TIGHT_COMPRESSED_STONE) && ((TightCompressStone.Heat)((Object)bsT.getValue(TightCompressStone.HEAT))).equals((Object)TightCompressStone.Heat.REGULAR_HEAT);
    }

    private static void setNoneHeatBlock(Level level, BlockPos pos) {
        level.setBlock(pos, (BlockState)CHBlocks.TIGHT_COMPRESSED_STONE.getDefaultState().setValue(TightCompressStone.HEAT, (Comparable)((Object)TightCompressStone.Heat.NONE)), 3);
    }

    public static boolean isAvailableSuperHeatBlock(BlockState bsT) {
        return bsT.is(CHBlocks.TIGHT_COMPRESSED_STONE) && ((TightCompressStone.Heat)((Object)bsT.getValue(TightCompressStone.HEAT))).equals((Object)TightCompressStone.Heat.SUPER_HEAT);
    }

    private static void setRegularHeatBlock(Level level, BlockPos pos) {
        level.setBlock(pos, (BlockState)CHBlocks.TIGHT_COMPRESSED_STONE.getDefaultState().setValue(TightCompressStone.HEAT, (Comparable)((Object)TightCompressStone.Heat.REGULAR_HEAT)), 3);
    }

    private static void setSuperHeatBlock(Level level, BlockPos pos) {
        level.setBlock(pos, (BlockState)CHBlocks.TIGHT_COMPRESSED_STONE.getDefaultState().setValue(TightCompressStone.HEAT, (Comparable)((Object)TightCompressStone.Heat.SUPER_HEAT)), 3);
    }

    public static boolean isAvailableTStoneBlock(BlockState bsT) {
        return bsT.is((Block)CHBlocks.TIGHT_COMPRESSED_STONE.get());
    }

    private static int calculateCapacity(Set<BlockPos> stonePosSet) {
        return stonePosSet.size() * HEAT_PER_LAVA.get();
    }

    public void fromNbt(CompoundTag nbt, Set<BlockPos> stonePS) {
        this.fromNbt(nbt);
        this.stonePosSet.clear();
        this.stonePosSet.addAll(stonePS);
        this.superHeatCount = nbt.getInt("super_heat_count");
    }

    @Override
    public CompoundTag toNbt() {
        CompoundTag nbt = super.toNbt();
        nbt.putInt("super_heat_count", this.superHeatCount);
        return nbt;
    }

    public boolean isConnect(Set<BlockPos> posSet) {
        return BlockUtil.isConnect(this.stonePosSet, posSet);
    }

    private static class BlockCounts {
        private Integer stone;
        private Integer regular;
        private Integer superHeat;

        public BlockCounts(int stone, int regular, int superHeat) {
            this.stone = stone;
            this.regular = regular;
            this.superHeat = superHeat;
        }

        public BlockCounts() {
        }

        public boolean unInit() {
            return this.stone == null || this.regular == null || this.superHeat == null;
        }

        public String toString() {
            return "BlockCounts{stone=" + this.stone + ", regular=" + this.regular + ", superHeat=" + this.superHeat + "}";
        }
    }
}

