/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.tightCompressStone;

import com.ffsupver.createheat.block.ConnectableBlockEntity;
import com.ffsupver.createheat.block.thermalBlock.ThermalBlockEntityBehaviour;
import com.ffsupver.createheat.block.tightCompressStone.StoneHeatStorage;
import com.ffsupver.createheat.util.NbtUtil;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TightCompressStoneEntity
extends ConnectableBlockEntity<TightCompressStoneEntity> {
    private final StoneHeatStorage stoneHeatStorage = new StoneHeatStorage(new HashSet<BlockPos>(Set.of(this.getBlockPos())));
    private final Map<BlockPos, Integer> superHeatTakenByTh = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, Integer> superHeatProvideByTh = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, Integer> superHeatActuallyProvideByTh = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, Integer> superHeatMergeCashe = new HashMap<BlockPos, Integer>();
    private int coolDown = 0;
    private int lastAmount;
    private int maxSuperHeatHold;

    public TightCompressStoneEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.isController()) {
            tag.put("shs", (Tag)this.stoneHeatStorage.toNbt());
            tag.putInt("max_super_heat", this.maxSuperHeatHold);
            tag.put("taken_map", (Tag)NbtUtil.writeMapToNbtList(this.superHeatTakenByTh, NbtUtil::blockPosToNbt, NbtUtil::intToNbt));
            tag.put("provide_map", (Tag)NbtUtil.writeMapToNbtList(this.superHeatProvideByTh, NbtUtil::blockPosToNbt, NbtUtil::intToNbt));
            tag.put("a_provide_map", (Tag)NbtUtil.writeMapToNbtList(this.superHeatActuallyProvideByTh, NbtUtil::blockPosToNbt, NbtUtil::intToNbt));
        }
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (this.isController()) {
            this.stoneHeatStorage.fromNbt(tag.getCompound("shs"), this.getConnectedBlocks());
            this.maxSuperHeatHold = tag.getInt("max_super_heat");
            this.superHeatTakenByTh.clear();
            this.superHeatTakenByTh.putAll(NbtUtil.readMapFromNbtList(tag.getList("taken_map", 10), NbtUtil::blockPosFromNbt, NbtUtil::intFromNbt));
            this.superHeatProvideByTh.clear();
            this.superHeatProvideByTh.putAll(NbtUtil.readMapFromNbtList(tag.getList("provide_map", 10), NbtUtil::blockPosFromNbt, NbtUtil::intFromNbt));
            this.superHeatActuallyProvideByTh.clear();
            this.superHeatActuallyProvideByTh.putAll(NbtUtil.readMapFromNbtList(tag.getList("a_provide_map", 10), NbtUtil::blockPosFromNbt, NbtUtil::intFromNbt));
        }
    }

    public void tick() {
        super.tick();
        if (!this.isController()) {
            return;
        }
        if (this.coolDown > 0) {
            --this.coolDown;
        } else {
            this.coolDown = 10;
            boolean removed = this.removeDisconnect();
            boolean change = this.stoneHeatStorage.checkSize(this.getLevel(), this.getConnectedBlocks());
            int superHeatCount = this.getSuperHeatBlockCount();
            this.stoneHeatStorage.setSuperHeatCount(superHeatCount);
            boolean bl = change = this.stoneHeatStorage.updateBlockState(this.getLevel()) || change;
            if (this.calculateSuperHeatCountActuallyProvide() > this.stoneHeatStorage.getSuperHeatCount()) {
                this.reduceSuperCountActuallyProvideToSHSSuperC();
            }
            this.maxSuperHeatHold = this.stoneHeatStorage.getMaxSuperHeatCount();
            if (change || this.lastAmount != this.stoneHeatStorage.getAmount() || removed) {
                this.notifyUpdate();
            }
            this.lastAmount = this.stoneHeatStorage.getAmount();
        }
    }

    private boolean removeDisconnect() {
        boolean removed = TightCompressStoneEntity.removeCountMap(this.superHeatTakenByTh, this.getLevel(), ((TightCompressStoneEntity)((Object)this.getControllerEntity())).stoneHeatStorage);
        removed = TightCompressStoneEntity.removeCountMap(this.superHeatProvideByTh, this.getLevel(), ((TightCompressStoneEntity)((Object)this.getControllerEntity())).stoneHeatStorage) || removed;
        removed = TightCompressStoneEntity.removeCountMap(this.superHeatActuallyProvideByTh, this.getLevel(), ((TightCompressStoneEntity)((Object)this.getControllerEntity())).stoneHeatStorage) || removed;
        return removed;
    }

    private int getSuperHeatBlockCount() {
        int bC = 0;
        for (Map.Entry<BlockPos, Integer> entry : this.superHeatActuallyProvideByTh.entrySet()) {
            bC += (this.superHeatProvideByTh.containsKey(entry.getKey()) ? this.superHeatProvideByTh.get(entry.getKey()) : entry.getValue()).intValue();
        }
        return bC;
    }

    public boolean isConnect(Set<BlockPos> posSet) {
        return this.getControllerEntity() != null && ((TightCompressStoneEntity)((Object)this.getControllerEntity())).stoneHeatStorage.isConnect(posSet);
    }

    public int insert(int toInsert) {
        return this.getControllerEntity() == null ? toInsert : ((TightCompressStoneEntity)((Object)this.getControllerEntity())).stoneHeatStorage.insert(toInsert);
    }

    public int extract(int toExtract, boolean simulate) {
        return this.getControllerEntity() == null ? 0 : ((TightCompressStoneEntity)((Object)this.getControllerEntity())).stoneHeatStorage.extract(toExtract, simulate);
    }

    public int addSuperHeatCount(int count, int total, boolean usingHeater, BlockPos controllerPos) {
        if (this.isController()) {
            if (usingHeater) {
                int lastProvide;
                if (this.superHeatProvideByTh.containsKey(controllerPos) && total < (lastProvide = this.superHeatProvideByTh.get(controllerPos).intValue())) {
                    this.superHeatProvideByTh.replace(controllerPos, total);
                }
                int nowProvider = this.superHeatProvideByTh.getOrDefault(controllerPos, 0);
                int totalProvide = this.calculateSuperHeatCountProvide();
                int leftToHold = this.stoneHeatStorage.getMaxSuperHeatCount() - totalProvide + nowProvider;
                int addProvide = Math.min(total, leftToHold);
                this.updateSuperCountActuallyProvide(controllerPos, count);
                this.updateSuperCountProvide(controllerPos, addProvide);
                return total - addProvide;
            }
            if (this.superHeatTakenByTh.containsKey(controllerPos)) {
                int oldTaken = this.superHeatTakenByTh.get(controllerPos);
                if (count > oldTaken) {
                    this.superHeatTakenByTh.remove(controllerPos);
                    return count - oldTaken;
                }
                this.superHeatTakenByTh.replace(controllerPos, oldTaken - count);
                return 0;
            }
            return count;
        }
        return this.getControllerEntity() == null ? (usingHeater ? total : count) : ((TightCompressStoneEntity)((Object)this.getControllerEntity())).addSuperHeatCount(count, total, usingHeater, controllerPos);
    }

    public int releaseSuperHeatCount(BlockPos controllerPos) {
        if (this.isController()) {
            this.updateSuperCountTaken(controllerPos, 0);
            int totalLeft = this.calculateSuperHeatCountActuallyProvide() - this.calculateSuperHeatCountTaken();
            this.updateSuperCountTaken(controllerPos, totalLeft);
            if (this.superHeatMergeCashe.containsKey(controllerPos)) {
                TightCompressStoneEntity.updateCountMap(this.superHeatActuallyProvideByTh, controllerPos, this.superHeatMergeCashe.get(controllerPos));
                this.superHeatMergeCashe.remove(controllerPos);
            } else if (this.superHeatProvideByTh.containsKey(controllerPos)) {
                this.superHeatActuallyProvideByTh.replace(controllerPos, this.superHeatProvideByTh.get(controllerPos));
                this.reduceSuperCountActuallyProvideToSHSSuperC();
                this.superHeatProvideByTh.remove(controllerPos);
            }
            return totalLeft;
        }
        return this.getControllerEntity() == null ? 0 : ((TightCompressStoneEntity)((Object)this.getControllerEntity())).releaseSuperHeatCount(controllerPos);
    }

    public void switchTControllerTo(BlockPos oldPos, BlockPos newPos) {
        TightCompressStoneEntity.mergeCountMap(this.superHeatTakenByTh, newPos, oldPos);
        TightCompressStoneEntity.mergeCountMap(this.superHeatActuallyProvideByTh, newPos, oldPos);
        TightCompressStoneEntity.updateCountMap(this.superHeatProvideByTh, newPos, this.superHeatActuallyProvideByTh.get(newPos));
        this.superHeatMergeCashe.replace(newPos, this.superHeatActuallyProvideByTh.get(newPos));
        this.notifyUpdate();
    }

    private void updateSuperCountProvide(BlockPos pos, int count) {
        TightCompressStoneEntity.updateCountMap(this.superHeatProvideByTh, pos, count);
    }

    private void updateSuperCountActuallyProvide(BlockPos pos, int count) {
        TightCompressStoneEntity.updateCountMap(this.superHeatActuallyProvideByTh, pos, count);
        this.reduceSuperCountActuallyProvideToSHSSuperC();
    }

    private void reduceSuperCountActuallyProvideToSHSSuperC() {
        TightCompressStoneEntity.reduceCountMapTo(this.superHeatActuallyProvideByTh, this.stoneHeatStorage.getSuperHeatCount());
    }

    private void updateSuperCountTaken(BlockPos pos, int count) {
        TightCompressStoneEntity.updateCountMap(this.superHeatTakenByTh, pos, count);
    }

    public void notifyUpdate() {
        super.notifyUpdate();
        HashSet<BlockPos> connectThBlockPos = new HashSet<BlockPos>();
        connectThBlockPos.addAll(this.superHeatTakenByTh.keySet());
        connectThBlockPos.addAll(this.superHeatProvideByTh.keySet());
        connectThBlockPos.addAll(this.superHeatActuallyProvideByTh.keySet());
        for (BlockPos thPos : connectThBlockPos) {
            ConnectableBlockEntity connectableBlockEntity;
            ThermalBlockEntityBehaviour thermalBlockEntityBehaviour;
            BlockEntity blockEntity = this.getLevel().getBlockEntity(thPos);
            if (!(blockEntity instanceof ConnectableBlockEntity) || (thermalBlockEntityBehaviour = ThermalBlockEntityBehaviour.getFromCBE(connectableBlockEntity = (ConnectableBlockEntity)blockEntity)) == null) continue;
            thermalBlockEntityBehaviour.sendData();
        }
    }

    private static void updateCountMap(Map<BlockPos, Integer> toUpdate, BlockPos pos, int count) {
        if (toUpdate.containsKey(pos)) {
            toUpdate.replace(pos, count);
        } else {
            toUpdate.put(pos, count);
        }
    }

    private static void mergeCountMap(Map<BlockPos, Integer> toUpdate, BlockPos pos, BlockPos oldPos) {
        int count = toUpdate.getOrDefault(oldPos, 0) + toUpdate.getOrDefault(pos, 0);
        TightCompressStoneEntity.updateCountMap(toUpdate, pos, count);
        toUpdate.remove(oldPos);
    }

    private static int calculateTotalCountMap(Map<BlockPos, Integer> toSum) {
        int taken = 0;
        for (Integer t : toSum.values()) {
            taken += t.intValue();
        }
        return taken;
    }

    private static void reduceCountMapTo(Map<BlockPos, Integer> toReduce, int reduceTo) {
        int currentSum = 0;
        for (Map.Entry<BlockPos, Integer> e : toReduce.entrySet()) {
            int t = e.getValue();
            if (currentSum + t < reduceTo) {
                currentSum += t;
                continue;
            }
            toReduce.replace(e.getKey(), reduceTo - currentSum);
            currentSum = reduceTo;
        }
    }

    private static boolean removeCountMap(Map<BlockPos, Integer> toRemove, Level level, StoneHeatStorage stoneHeatStorage) {
        ArrayList<BlockPos> toRemoveList = new ArrayList<BlockPos>();
        for (BlockPos key : toRemove.keySet()) {
            ThermalBlockEntityBehaviour tBEB;
            ConnectableBlockEntity connectableBlockEntity;
            boolean shouldNotRemove = false;
            BlockEntity blockEntity = level.getBlockEntity(key);
            if (blockEntity instanceof ConnectableBlockEntity && (connectableBlockEntity = (ConnectableBlockEntity)blockEntity).isController() && (tBEB = ThermalBlockEntityBehaviour.getFromCBE(connectableBlockEntity)) != null && tBEB.isConnectTo(stoneHeatStorage)) {
                shouldNotRemove = true;
            }
            if (shouldNotRemove) continue;
            toRemoveList.add(key);
        }
        toRemoveList.forEach(toRemove::remove);
        return !toRemoveList.isEmpty();
    }

    private int calculateSuperHeatCountTaken() {
        return TightCompressStoneEntity.calculateTotalCountMap(this.superHeatTakenByTh);
    }

    private int calculateSuperHeatCountProvide() {
        return TightCompressStoneEntity.calculateTotalCountMap(this.superHeatProvideByTh);
    }

    private int calculateSuperHeatCountActuallyProvide() {
        return TightCompressStoneEntity.calculateTotalCountMap(this.superHeatActuallyProvideByTh);
    }

    public StoneHeatStorage getStoneHeatStorage() {
        return this.stoneHeatStorage;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public boolean canConnect(ConnectableBlockEntity toCheck) {
        return toCheck instanceof TightCompressStoneEntity;
    }

    @Override
    protected TightCompressStoneEntity castToSubclass() {
        return this;
    }
}

