/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.compat.anvilCraft;

import com.ffsupver.createheat.Config;
import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.block.HeatTransferProcesser;
import dev.dubhe.anvilcraft.block.entity.HeatCollectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class HeatCollectorTransferProcesser
extends HeatTransferProcesser {
    public static final ResourceLocation TYPE = CreateHeat.asResource("anvil_craft_heat_collector");
    private static final int MAX_COOLDOWN = 4;
    private int coolDown = 0;
    private int totalPerCoolDown = 0;
    private int avgHeatPerTick;

    protected HeatCollectorTransferProcesser() {
        super(TYPE);
    }

    @Override
    public boolean needHeat(Level level, BlockPos pos, @Nullable Direction face) {
        return level.getBlockEntity(pos) instanceof HeatCollectorBlockEntity;
    }

    @Override
    public void acceptHeat(Level level, BlockPos hTPPos, int heatProvide, int tickSkip) {
        BlockEntity blockEntity = level.getBlockEntity(hTPPos);
        if (blockEntity instanceof HeatCollectorBlockEntity) {
            HeatCollectorBlockEntity heatCollectorBlockEntity = (HeatCollectorBlockEntity)blockEntity;
            boolean shouldAddHeat = this.acceptHeatToTotal(heatProvide, tickSkip);
            int superHeatCount = this.avgHeatPerTick / (Integer)Config.HEAT_PER_SEETHING_BLAZE.get();
            if (shouldAddHeat) {
                int heatToInput = superHeatCount * 4 / 2;
                heatCollectorBlockEntity.inputtingHeat(heatToInput);
            }
        }
    }

    private boolean acceptHeatToTotal(int heatProvide, int tickSkip) {
        this.coolDown += tickSkip;
        this.totalPerCoolDown += heatProvide;
        if (this.coolDown >= 4) {
            int actuallyTick = this.coolDown;
            this.coolDown = 0;
            this.avgHeatPerTick = this.totalPerCoolDown / actuallyTick;
            this.totalPerCoolDown = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldProcessEveryTick() {
        return true;
    }
}

