/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.compat.anvilCraft;

import com.ffsupver.createheat.CHTags;
import com.ffsupver.createheat.block.ConnectableBlockEntity;
import com.ffsupver.createheat.block.thermalBlock.ThermalBlockEntityBehaviour;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.boiler.BoilerHeater;
import dev.dubhe.anvilcraft.api.heat.HeatTier;
import dev.dubhe.anvilcraft.api.heat.HeatTierLine;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class HeatProducerBoilHeater
implements BoilerHeater {
    public static TagKey<Block> BLOCK_TAG = CHTags.BlockTag.CAN_HEAT_THROUGH;
    private static Map<BlockPos, HeatTierLine.Point> heatableBlocksMapCached = Map.of();

    public static void updateHeatableBlockMap(Map<BlockPos, HeatTierLine.Point> newMap) {
        heatableBlocksMapCached = newMap;
    }

    public float getHeat(Level level, BlockPos pos, BlockState state) {
        BlockPos posUp = pos.above();
        if (!HeatProducerBoilHeater.canHeatBlock(level, posUp)) {
            return -1.0f;
        }
        if (!state.is(BLOCK_TAG) || !heatableBlocksMapCached.containsKey(posUp)) {
            return -1.0f;
        }
        HeatTierLine.Point point = heatableBlocksMapCached.get(posUp);
        return switch (point.tier()) {
            default -> throw new MatchException(null, null);
            case HeatTier.NORMAL -> -1.0f;
            case HeatTier.HEATED -> 0.0f;
            case HeatTier.REDHOT -> 1.0f;
            case HeatTier.GLOWING -> 2.0f;
            case HeatTier.INCANDESCENT -> 3.0f;
            case HeatTier.OVERHEATED -> 4.0f;
        };
    }

    public static boolean canHeatBlock(Level level, BlockPos pos) {
        ConnectableBlockEntity c;
        BlockState state = level.getBlockState(pos);
        boolean isFluidTank = state.is((Block)AllBlocks.FLUID_TANK.get());
        BlockEntity blockEntity = level.getBlockEntity(pos);
        boolean isThermalBlock = blockEntity instanceof ConnectableBlockEntity && ThermalBlockEntityBehaviour.getFromCBE(c = (ConnectableBlockEntity)blockEntity) != null;
        return isFluidTank || isThermalBlock;
    }

    public static boolean shouldUpdateBoiler(BlockPos posBelowBoiler, ServerLevel level) {
        BlockState state = level.getBlockState(posBelowBoiler);
        return state.is(BLOCK_TAG);
    }
}

