/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.compat.anvilCraft;

import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.api.anvilCraft.HeatableBlockHeatTransferProcesserData;
import com.ffsupver.createheat.block.ConnectableBlockEntity;
import com.ffsupver.createheat.block.HeatTransferProcesser;
import com.ffsupver.createheat.block.MainHeatTransferProcesser;
import com.ffsupver.createheat.block.thermalBlock.ThermalBlockEntityBehaviour;
import com.ffsupver.createheat.util.BlockUtil;
import dev.dubhe.anvilcraft.api.heat.HeatTierLine;
import dev.dubhe.anvilcraft.api.heat.HeaterInfo;
import dev.dubhe.anvilcraft.api.heat.HeaterManager;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class HeatableBlockTransferProcesser
extends MainHeatTransferProcesser {
    public static final ResourceLocation TYPE = CreateHeat.asResource("anvil_craft_heatable_block_regular");
    private BlockPos heatPos;
    private ResourceLocation id;
    private int count;
    private HeaterInfo<HeatableBlockTransferProcesser> info = null;

    protected HeatableBlockTransferProcesser() {
        super(TYPE);
    }

    @Override
    public boolean needHeatBefore(Level level, BlockPos pos, @Nullable Direction face) {
        Optional<Holder.Reference<HeatableBlockHeatTransferProcesserData>> dataOptional = HeatableBlockHeatTransferProcesserData.getFromBlockState(level.getBlockState(pos), level.registryAccess());
        if (dataOptional.isPresent()) {
            ResourceLocation lastId = this.id;
            this.heatPos = pos;
            HeatableBlockHeatTransferProcesserData data = (HeatableBlockHeatTransferProcesserData)dataOptional.get().value();
            this.id = dataOptional.get().getKey().location();
            if (lastId != null && !lastId.equals((Object)this.id)) {
                HeaterManager.removeProducer((BlockPos)this.heatPos, (Level)level, this.info);
                return false;
            }
            if (this.info == null) {
                this.info = HeatableBlockTransferProcesser.createInfo(data.heatTierLine());
            }
            return true;
        }
        return false;
    }

    @Override
    public void acceptHeatAsMain(Level level, BlockPos hTPPos, int heatProvide, int tickSkip) {
        this.count = heatProvide / tickSkip;
        HeaterManager.addProducer((BlockPos)this.heatPos, (Level)level, this.info);
    }

    public Set<BlockPos> getHeatPosSet() {
        return Set.of(this.heatPos);
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public boolean shouldProcessEveryTick() {
        return false;
    }

    public static Optional<HeatableBlockTransferProcesser> getByLevelPos(Level level, BlockPos pos) {
        AtomicReference result = new AtomicReference(Optional.empty());
        BlockUtil.AllDirectionOf(pos, cPos -> {
            HeatTransferProcesser patt1$temp;
            Optional<HeatTransferProcesser> hTPOp;
            ConnectableBlockEntity cbe;
            ThermalBlockEntityBehaviour tBEB;
            BlockEntity patt0$temp = level.getBlockEntity(cPos);
            if (patt0$temp instanceof ConnectableBlockEntity && (tBEB = ThermalBlockEntityBehaviour.getFromCBE(cbe = (ConnectableBlockEntity)patt0$temp)) != null && (hTPOp = tBEB.getHeatTransferProcesserByOther(pos)).isPresent() && (patt1$temp = hTPOp.get()) instanceof HeatableBlockTransferProcesser) {
                HeatableBlockTransferProcesser hBTP = (HeatableBlockTransferProcesser)patt1$temp;
                if (hBTP.isMainProcesser) {
                    result.set(Optional.of(hBTP));
                }
            }
        }, p -> ((Optional)result.get()).isPresent());
        return result.get();
    }

    public static HeaterInfo<HeatableBlockTransferProcesser> createInfo(HeatTierLine heatTierLine) {
        return new HeaterInfo(HeatableBlockTransferProcesser::getByLevelPos, HeatableBlockTransferProcesser::getHeatPosSet, heatTierLine, HeatableBlockTransferProcesser::getCount);
    }
}

