/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.compat.pneumaticcraft;

import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.block.HeatTransferProcesser;
import com.ffsupver.createheat.compat.CHModCompat;
import com.ffsupver.createheat.compat.Mods;
import com.ffsupver.createheat.registries.CHBoilerUpdaters;
import com.ffsupver.createheat.registries.CHHeatTransferProcessers;
import com.simibubi.create.api.boiler.BoilerHeater;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import org.jetbrains.annotations.Nullable;

public class Pneumaticcraft
implements CHModCompat {
    @Override
    public String getModId() {
        return Mods.ModIds.PNEUMATICCRAFT.ModId;
    }

    @Override
    public void init(IEventBus eventBus) {
        CHHeatTransferProcessers.registerHeatTransferProcesser(PneumaticcraftHeatTransferProcesser.TYPE.getPath(), () -> PneumaticcraftHeatTransferProcesser::new);
        CHBoilerUpdaters.registerBoilerUpdater((posBelowBoiler, level) -> {
            IHeatExchangingTE iHeatExchangingTE;
            BlockEntity patt0$temp;
            return level.getBlockState(posBelowBoiler).is((Block)ModBlocks.VORTEX_TUBE.get()) && (patt0$temp = level.getBlockEntity(posBelowBoiler)) instanceof IHeatExchangingTE && (iHeatExchangingTE = (IHeatExchangingTE)patt0$temp).getHeatExchanger(Direction.UP) != null;
        });
    }

    @Override
    public void registerBoilerHeater() {
        BoilerHeater.REGISTRY.register((Object)((Block)ModBlocks.VORTEX_TUBE.get()), (level, pos, state) -> {
            IHeatExchangingTE iHeatExchangingTE;
            IHeatExchangerLogic iHeatExchangerLogic;
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof IHeatExchangingTE && (iHeatExchangerLogic = (iHeatExchangingTE = (IHeatExchangingTE)patt0$temp).getHeatExchanger(Direction.UP)) != null) {
                double temperature = iHeatExchangerLogic.getTemperature();
                return temperature >= 805.0 ? (float)(iHeatExchangerLogic.getTemperature() / 805.0) : (temperature > 390.0 ? 0.0f : -1.0f);
            }
            return -1.0f;
        });
    }

    public static class PneumaticcraftHeatTransferProcesser
    extends HeatTransferProcesser {
        private static final ResourceLocation TYPE = CreateHeat.asResource("pneumaticcraft_compat");

        protected PneumaticcraftHeatTransferProcesser() {
            super(TYPE);
        }

        @Override
        public boolean needHeat(Level level, BlockPos hTPPos, @Nullable Direction face) {
            if (level.getBlockState(hTPPos).is((Block)ModBlocks.VORTEX_TUBE.get())) {
                return false;
            }
            IHeatExchangingTE heatExchangerLogic = this.getHeatExchangeLogic(level, hTPPos);
            return heatExchangerLogic != null;
        }

        @Override
        public void acceptHeat(Level level, BlockPos hTPPos, int heatProvide, int tickSkip) {
            IHeatExchangingTE heatExchangingTE = this.getHeatExchangeLogic(level, hTPPos);
            if (heatExchangingTE != null) {
                heatExchangingTE.getHeatExchanger().addHeat((double)heatProvide * 1.9);
            }
        }

        @Override
        public boolean shouldProcessEveryTick() {
            return true;
        }

        private IHeatExchangingTE getHeatExchangeLogic(Level level, BlockPos pos) {
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof IHeatExchangingTE) {
                IHeatExchangingTE heatExchangingTE = (IHeatExchangingTE)entity;
                return heatExchangingTE;
            }
            return null;
        }
    }
}

