/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.compat.ponder.scenes.iceAndFire;

import com.ffsupver.createheat.compat.ponder.scenes.ThermalBlockScene;
import com.iafenvoy.iceandfire.entity.FireDragonEntity;
import com.iafenvoy.iceandfire.particle.DragonFlameParticleType;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class DragonFireInputScenes {
    public static void use(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("ice_and_fire.use", "Using Dragon Fire Input");
        scene.scaleSceneView(0.5f);
        scene.configureBasePlate(0, 0, 13);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.world().showSection(util.select().fromTo(4, 2, 8, 4, 3, 8), Direction.DOWN);
        scene.world().showSection(util.select().fromTo(4, 3, 9, 4, 3, 11), Direction.DOWN);
        scene.world().showSection(util.select().fromTo(3, 3, 11, 1, 3, 11), Direction.DOWN);
        scene.idle(10);
        BlockPos dragonFireInput = util.grid().at(4, 2, 8);
        scene.world().createEntity(level -> {
            FireDragonEntity fireDragon = new FireDragonEntity((EntityType)IafEntities.FIRE_DRAGON.get(), level);
            fireDragon.setAgeInDays(50);
            BlockPos blockPos = util.grid().at(7, 1, 3);
            fireDragon.setPos(blockPos.getCenter());
            fireDragon.setInSittingPose(true);
            fireDragon.burningTarget = dragonFireInput;
            return fireDragon;
        });
        scene.overlay().showText(20).text("Dragon Fire Input can turn dragon fire into heat").pointAt(dragonFireInput.getCenter());
        scene.idle(30);
        scene.world().showSection(util.select().position(4, 1, 8), Direction.UP);
        scene.overlay().showText(20).text("Place any Dragon Forge Bricks next to Dragon Fire Input to select dragon type you want").pointAt(dragonFireInput.below().getCenter());
        scene.world().modifyEntities(FireDragonEntity.class, fireDragonEntity -> {
            fireDragonEntity.setInSittingPose(false);
            fireDragonEntity.getLookControl().setLookAt(dragonFireInput.getCenter());
            fireDragonEntity.updateBurnTarget();
        });
        int totalTickLeft = 100;
        DragonFireInputScenes.dragonBrunTicks(scene, 30, dragonFireInput, 0.0f, 30.0f / (float)totalTickLeft);
        scene.world().showSection(util.select().fromTo(3, 4, 11, 1, 6, 11), Direction.DOWN);
        for (int i = 0; i < 3; ++i) {
            int x = 1 + i;
            BlockPos basinPos = util.grid().at(x, 4, 11);
            scene.world().createItemEntity(util.vector().centerOf(basinPos.above(1)), util.vector().of(0.0, 0.0, 0.0), new ItemStack((ItemLike)Items.COPPER_INGOT));
            scene.world().createItemEntity(util.vector().centerOf(basinPos.above(1)), util.vector().of(0.0, 0.0, 0.0), new ItemStack((ItemLike)AllItems.ZINC_INGOT.asItem()));
            scene.world().modifyBlock(util.grid().at(x, 3, 11), ThermalBlockScene.setHeatLevel(BlazeBurnerBlock.HeatLevel.SEETHING), false);
            scene.world().setKineticSpeed(util.select().position(x, 6, 11), (float)(-(x % 2) * 2 + 1) * 64.0f);
            scene.world().modifyBlockEntity(util.grid().at(x, 6, 11), MechanicalMixerBlockEntity.class, MechanicalMixerBlockEntity::startProcessingBasin);
        }
        scene.overlay().showText(20).text("Dragon Fire Input will provide heat").pointAt(util.grid().at(1, 6, 11).getCenter());
        DragonFireInputScenes.dragonBrunTicks(scene, 70, dragonFireInput, 30.0f / (float)totalTickLeft, 100.0f / (float)totalTickLeft);
        scene.markAsFinished();
    }

    private static void dragonBrunTicks(CreateSceneBuilder scene, int ticks, BlockPos burnPos, float progressStart, float progressEnd) {
        float totalBurnProgress = 40.0f * (progressEnd - progressStart);
        float baseBurnProgress = 40.0f * progressStart;
        for (int tick = 0; tick < ticks; ++tick) {
            float progress = baseBurnProgress + totalBurnProgress / (float)ticks * (float)tick;
            scene.world().modifyEntities(FireDragonEntity.class, fireDragon -> DragonFireInputScenes.addFire(fireDragon, burnPos, progress));
            scene.idle(1);
        }
    }

    private static void addFire(FireDragonEntity fireDragon, BlockPos burnPos, float burnProgress) {
        float burnX = (float)burnPos.getX() + 0.5f;
        float burnY = (float)burnPos.getY() + 0.5f;
        float burnZ = (float)burnPos.getZ() + 0.5f;
        Vec3 headPos = fireDragon.getHeadPosition();
        double d2 = (double)burnX - headPos.x;
        double d3 = (double)burnY - headPos.y;
        double d4 = (double)burnZ - headPos.z;
        double distance = Math.max(2.5 * Math.sqrt(fireDragon.distanceToSqr((double)burnX, (double)burnY, (double)burnZ)), 0.0);
        double conqueredDistance = (double)burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = d2 * (double)((float)i / (float)distance);
            double progressY = d3 * (double)((float)i / (float)distance);
            double progressZ = d4 * (double)((float)i / (float)distance);
            Vec3 velocity = new Vec3(progressX, progressY, progressZ);
            fireDragon.level().addParticle((ParticleOptions)new DragonFlameParticleType(fireDragon.getAgeScale()), headPos.x, headPos.y, headPos.z, velocity.x, velocity.y, velocity.z);
            i += increment;
        }
    }
}

