/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.item.thermalTool;

import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.item.thermalTool.ThermalToolUseActions;
import com.ffsupver.createheat.util.BlockUtil;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ThermalTool
extends Item {
    public ThermalTool(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        boolean shiftDown;
        Player player;
        BlockState state;
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        boolean used = ThermalToolUseActions.onUse(level, pos, state = level.getBlockState(pos), player = context.getPlayer(), shiftDown = player.isShiftKeyDown());
        if (used) {
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public static boolean attackOnBlock(Level level, BlockPos pos, BlockState state, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (state.is((Holder)AllBlocks.FLUID_TANK)) {
                if (!player.isShiftKeyDown()) {
                    return ThermalTool.placeBoiler(serverLevel, pos);
                }
                return ThermalTool.removeBoiler(serverLevel, pos, player);
            }
        }
        return false;
    }

    private static boolean placeBoiler(ServerLevel serverLevel, BlockPos pos) {
        Optional structureTemplateOp;
        boolean canPlace = true;
        block0: for (int i = -1; i < 2 && canPlace; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == 0 && j == 0 || serverLevel.getBlockState(pos.offset(i, 0, j)).isAir()) continue;
                canPlace = false;
                continue block0;
            }
        }
        if (canPlace && (structureTemplateOp = serverLevel.getStructureManager().get(CreateHeat.asResource("boiler"))).isPresent()) {
            StructurePlaceSettings settings = new StructurePlaceSettings().setRotation(Rotation.NONE);
            BlockPos posToPlace = pos.offset(-1, 0, -1);
            ((StructureTemplate)structureTemplateOp.get()).placeInWorld((ServerLevelAccessor)serverLevel, posToPlace, posToPlace, settings, serverLevel.getRandom(), 2);
            serverLevel.playSound(null, posToPlace, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 2.0f, 1.0f);
            return true;
        }
        return false;
    }

    private static boolean removeBoiler(ServerLevel serverLevel, BlockPos pos, Player player) {
        HashSet<BlockPos> NeedRemovePosSet = new HashSet<BlockPos>();
        BlockUtil.walkAllBlocks(pos, NeedRemovePosSet, b -> {
            BlockState state = serverLevel.getBlockState(b);
            if (state.is((Holder)AllBlocks.STEAM_ENGINE)) {
                BlockPos shaftPos = b.relative(SteamEngineBlock.getFacing((BlockState)state), 2);
                if (serverLevel.getBlockState(shaftPos).is((Holder)AllBlocks.POWERED_SHAFT)) {
                    NeedRemovePosSet.add(shaftPos);
                }
                return true;
            }
            return state.is((Holder)AllBlocks.FLUID_TANK);
        }, 64);
        NeedRemovePosSet.forEach(p -> serverLevel.destroyBlock(p, false, (Entity)player));
        return !NeedRemovePosSet.isEmpty();
    }
}

