/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.item.thermalTool;

import com.ffsupver.createheat.item.thermalTool.ThermalToolPointLogic;
import com.ffsupver.createheat.item.thermalTool.ThermalToolPointRenderPack;
import com.ffsupver.createheat.item.thermalTool.ThermalToolPointType;
import com.ffsupver.createheat.util.NbtUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class ThermalToolPointServer {
    private static String ID = "thermal_tool_point_server";
    private static PointMapData pointMapData;
    private static boolean needToUpdate;

    public static void registerEvent() {
        NeoForge.EVENT_BUS.addListener(ThermalToolPointServer::onPlayerChangeDimension);
        NeoForge.EVENT_BUS.addListener(ThermalToolPointServer::onPlayerLogin);
    }

    private static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ThermalToolPointServer.upDateToPlayer((PlayerEvent)event, (ResourceKey<Level>)event.getTo());
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ThermalToolPointServer.upDateToPlayer((PlayerEvent)event, (ResourceKey<Level>)event.getEntity().level().dimension());
    }

    private static void upDateToPlayer(PlayerEvent event, ResourceKey<Level> levelKey) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ThermalToolPointServer.sendToPlayer(serverPlayer, ThermalToolPointServer.getRenderMap(levelKey));
        }
    }

    public static void tick(ServerTickEvent event) {
        MinecraftServer server = event.getServer();
        if (pointMapData == null && (pointMapData = (PointMapData)server.overworld().getDataStorage().get(PointMapData.factory(), ID)) == null) {
            pointMapData = new PointMapData();
            needToUpdate = true;
        }
        Map<ResourceKey<Level>, Map<BlockPos, ThermalToolPointLogic>> points = ThermalToolPointServer.pointMapData.pointMaps;
        points.forEach((levelKey, pointMap) -> {
            ServerLevel level = server.getLevel(levelKey);
            if (level == null) {
                return;
            }
            pointMap.forEach((pos, logic) -> {
                if (level.isLoaded(pos)) {
                    logic.tick(level, (BlockPos)pos);
                }
            });
        });
        if (needToUpdate) {
            server.getAllLevels().forEach(serverLevel -> {
                if (points.containsKey(serverLevel.dimension())) {
                    Map<BlockPos, ThermalToolPointType> renderMap = ThermalToolPointServer.getRenderMap((ResourceKey<Level>)serverLevel.dimension());
                    serverLevel.players().forEach(player -> ThermalToolPointServer.sendToPlayer(player, renderMap));
                }
            });
            PointMapData pointMapData = new PointMapData();
            pointMapData.pointMaps.putAll(points);
            server.overworld().getDataStorage().set(ID, (SavedData)pointMapData);
            pointMapData.setDirty(true);
            needToUpdate = false;
        }
    }

    private static Map<BlockPos, ThermalToolPointType> getRenderMap(ResourceKey<Level> levelKey) {
        HashMap<BlockPos, ThermalToolPointType> renderMap = new HashMap<BlockPos, ThermalToolPointType>();
        if (ThermalToolPointServer.points().containsKey(levelKey)) {
            ThermalToolPointServer.points().get(levelKey).forEach((pos, logic) -> renderMap.put((BlockPos)pos, logic.getType()));
        }
        return renderMap;
    }

    private static Map<ResourceKey<Level>, Map<BlockPos, ThermalToolPointLogic>> points() {
        return ThermalToolPointServer.pointMapData.pointMaps;
    }

    private static void sendToPlayer(ServerPlayer player, Map<BlockPos, ThermalToolPointType> renderMap) {
        ThermalToolPointRenderPack pointRenderPack = new ThermalToolPointRenderPack(renderMap);
        player.connection.send((CustomPacketPayload)pointRenderPack);
    }

    public static void tiggerPoint(ServerLevel serverLevel, BlockPos pos, ThermalToolPointLogic logic) {
        ResourceKey key = serverLevel.dimension();
        ThermalToolPointServer.points().putIfAbsent((ResourceKey<Level>)key, new HashMap());
        Map<BlockPos, ThermalToolPointLogic> levelPointMap = ThermalToolPointServer.points().get(key);
        if (levelPointMap.containsKey(pos)) {
            ThermalToolPointLogic newLogic = levelPointMap.get(pos).nextLogic(serverLevel, pos);
            if (newLogic == null) {
                levelPointMap.remove(pos);
            } else {
                levelPointMap.replace(pos, newLogic);
            }
        } else {
            levelPointMap.putIfAbsent(pos, logic);
        }
        ThermalToolPointServer.onPointsChange();
    }

    private static void onPointsChange() {
        needToUpdate = true;
    }

    public static ThermalToolPointLogic getPoint(ResourceKey<Level> levelKey, BlockPos pos) {
        Map<ResourceKey<Level>, Map<BlockPos, ThermalToolPointLogic>> pM = ThermalToolPointServer.pointMapData.pointMaps;
        if (pM.containsKey(levelKey) && pM.get(levelKey).containsKey(pos)) {
            return pM.get(levelKey).get(pos);
        }
        return null;
    }

    static {
        needToUpdate = false;
    }

    public static class PointMapData
    extends SavedData {
        private final Map<ResourceKey<Level>, Map<BlockPos, ThermalToolPointLogic>> pointMaps = new HashMap<ResourceKey<Level>, Map<BlockPos, ThermalToolPointLogic>>();

        public static PointMapData load(CompoundTag tag, HolderLookup.Provider levelRegistry) {
            PointMapData pointMapData = new PointMapData();
            if (tag.contains("thermal_tool_points", 9)) {
                pointMapData.pointMaps.clear();
                pointMapData.pointMaps.putAll(NbtUtil.readMapFromNbtList(tag.getList("thermal_tool_points", 10), keyTag -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)NbtUtil.resourceLocationFromNbt(keyTag)), mapTag -> NbtUtil.readMapFromNbtList((ListTag)mapTag, NbtUtil::blockPosFromNbt, ThermalToolPointLogic::fromNbt)));
            }
            return pointMapData;
        }

        public static SavedData.Factory<PointMapData> factory() {
            return new SavedData.Factory(() -> {
                throw new RuntimeException("No Point Data");
            }, PointMapData::load, DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
        }

        public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
            ListTag pointTag = NbtUtil.writeMapToNbtList(this.pointMaps, key -> NbtUtil.resourceLocationToNbt(key.location()), map -> NbtUtil.writeMapToNbtList(map, NbtUtil::blockPosToNbt, ThermalToolPointLogic::toNbt));
            compoundTag.put("thermal_tool_points", (Tag)pointTag);
            return compoundTag;
        }

        public String toString() {
            return "PointMapData{pointMaps=" + String.valueOf(this.pointMaps) + "}";
        }
    }
}

