/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.item.thermalTool;

import com.ffsupver.createheat.block.ConnectableBlockEntity;
import com.ffsupver.createheat.block.thermalBlock.ThermalBlockEntityBehaviour;
import com.ffsupver.createheat.item.thermalTool.ThermalToolPointLogic;
import com.ffsupver.createheat.item.thermalTool.ThermalToolPointServer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ThermalToolUseActions {
    private static Map<LevelBlockPosTester, LevelBlockPosConsumer> ACTIONS = new HashMap<LevelBlockPosTester, LevelBlockPosConsumer>();

    public static void bootSetup() {
        ThermalToolUseActions.registerAction((level, pos, state, player, isShift) -> level.getBlockEntity(pos) instanceof ConnectableBlockEntity, (level, pos, state, player, isShift) -> {
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof ConnectableBlockEntity) {
                ConnectableBlockEntity connectableBlockEntity = (ConnectableBlockEntity)patt0$temp;
                return ThermalToolUseActions.userOnConnectableBlock(isShift, level, pos, connectableBlockEntity, player);
            }
            return false;
        });
        ThermalToolUseActions.registerAction(ThermalToolUseActions.isBlock((Holder<Block>)AllBlocks.FLUID_TANK), (level, pos, state, player, isShift) -> {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ThermalToolPointLogic logic = ThermalToolPointLogic.FLUID_TANK;
                ThermalToolPointServer.tiggerPoint(serverLevel, pos, logic);
            }
            return true;
        });
        ThermalToolUseActions.registerAction(ThermalToolUseActions.isBlock((Holder<Block>)AllBlocks.BLAZE_BURNER), (level, pos, state, player, isShift) -> {
            if (state.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL) != BlazeBurnerBlock.HeatLevel.NONE) {
                ItemStack creativeCake = AllItems.CREATIVE_BLAZE_CAKE.asStack();
                BlazeBurnerBlock.tryInsert((BlockState)state, (Level)level, (BlockPos)pos, (ItemStack)creativeCake, (boolean)true, (boolean)false, (boolean)false);
                return true;
            }
            return false;
        });
        ThermalToolUseActions.registerAction(ThermalToolUseActions.isBlock(Blocks.TNT), (level, pos, state, player, isShift) -> {
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 5.0f, true, Level.ExplosionInteraction.TRIGGER);
            }
            return true;
        });
    }

    public static void registerAction(LevelBlockPosTester tester, LevelBlockPosConsumer consumer) {
        ACTIONS.put(tester, consumer);
    }

    public static boolean onUse(Level level, BlockPos pos, BlockState state, Player player, boolean shiftDown) {
        for (Map.Entry<LevelBlockPosTester, LevelBlockPosConsumer> entry : ACTIONS.entrySet()) {
            boolean accepted;
            if (!entry.getKey().test(level, pos, state, player, shiftDown) || !(accepted = entry.getValue().accept(level, pos, state, player, shiftDown))) continue;
            return true;
        }
        return false;
    }

    public static LevelBlockPosTester isBlock(Block block) {
        return (level, pos, state, player, isShift) -> state.is(block);
    }

    public static LevelBlockPosTester isBlock(Holder<Block> block) {
        return (level, pos, state, player, isShift) -> state.is(block);
    }

    public static LevelBlockPosTester isBlock(HolderSet<Block> block) {
        return (level, pos, state, player, isShift) -> state.is(block);
    }

    public static LevelBlockPosTester isBlock(TagKey<Block> block) {
        return (level, pos, state, player, isShift) -> state.is(block);
    }

    private static boolean userOnConnectableBlock(boolean shiftDown, Level level, BlockPos pos, ConnectableBlockEntity<?> connectableBlockEntity, Player player) {
        BlockPos controllerPos = connectableBlockEntity.getControllerPos();
        ThermalBlockEntityBehaviour controllerEntity = (ThermalBlockEntityBehaviour)connectableBlockEntity.getBehaviour(ThermalBlockEntityBehaviour.TYPE);
        if (player != null && !level.isClientSide()) {
            if (shiftDown) {
                player.displayClientMessage((Component)Component.literal((String)("Connect count :" + controllerEntity.getBlockSize() + " heat:" + controllerEntity.getHeat() + " Controller x:" + controllerPos.getX() + " y:" + controllerPos.getY() + " z:" + controllerPos.getZ() + " heatStorage:" + String.valueOf(controllerEntity.getHeatStorage()))).withStyle(ChatFormatting.RED), true);
            } else if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ThermalToolPointServer.tiggerPoint(serverLevel, pos, ThermalToolPointLogic.HEAT_SOURCE);
            }
        }
        return true;
    }

    @FunctionalInterface
    public static interface LevelBlockPosTester {
        public boolean test(Level var1, BlockPos var2, BlockState var3, Player var4, boolean var5);
    }

    @FunctionalInterface
    public static interface LevelBlockPosConsumer {
        public boolean accept(Level var1, BlockPos var2, BlockState var3, Player var4, boolean var5);
    }
}

