/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.registries;

import com.ffsupver.createheat.Config;
import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.api.CustomHeater;
import com.ffsupver.createheat.api.SimpleHeatProvider;
import com.ffsupver.createheat.block.HeatProvider;
import com.ffsupver.createheat.item.thermalTool.ThermalToolPointLogic;
import com.ffsupver.createheat.item.thermalTool.ThermalToolPointServer;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class CHHeatProviders {
    private static final CreateRegistrate REGISTRATE = CreateHeat.registrate();
    public static final ResourceKey<Registry<HeatFinder>> HEAT_FINDER_REGISTRY_KEY = REGISTRATE.makeRegistry("heat_provider", RegistryBuilder::new);

    public static void registerHeatFinder(String name, Supplier<HeatFinder> heatFinderSupplier) {
        REGISTRATE.generic(name, HEAT_FINDER_REGISTRY_KEY, NonNullSupplier.of(heatFinderSupplier)).register();
    }

    public static void bootSetup() {
        CHHeatProviders.registerHeatFinder("block_entity", () -> (level, pos, state) -> {
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof HeatProvider) {
                HeatProvider provider = (HeatProvider)patt0$temp;
                return provider;
            }
            return null;
        });
        CHHeatProviders.registerHeatFinder("custom_heater", () -> (level, pos, state) -> {
            Optional<Holder.Reference<CustomHeater>> customHeatOp = CustomHeater.getFromBlockState(level.registryAccess(), level.getBlockState(pos));
            return customHeatOp.map(Holder.Reference::value).orElse(null);
        });
        CHHeatProviders.registerHeatFinder("thermal_tool_point", () -> (level, pos, state) -> {
            ThermalToolPointLogic logic = ThermalToolPointServer.getPoint((ResourceKey<Level>)level.dimension(), pos.above());
            if (ThermalToolPointLogic.HEAT_SOURCE.equals((Object)logic)) {
                return new SimpleHeatProvider((Integer)Config.HEAT_PER_FADING_BLAZE.get(), 0);
            }
            if (ThermalToolPointLogic.SUPER_HEAT_SOURCE.equals((Object)logic)) {
                return new SimpleHeatProvider((Integer)Config.HEAT_PER_SEETHING_BLAZE.get(), 1);
            }
            return null;
        });
    }

    public static Optional<HeatProvider> findHeatProvider(Level level, BlockPos pos, BlockState state) {
        return REGISTRATE.getAll(HEAT_FINDER_REGISTRY_KEY).stream().map(s -> ((HeatFinder)s.get()).getHeatProvider(level, pos, state)).filter(Objects::nonNull).findFirst();
    }

    @FunctionalInterface
    public static interface HeatFinder {
        public HeatProvider getHeatProvider(Level var1, BlockPos var2, BlockState var3);
    }
}

