/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.api.iceAndFire;

import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.block.HeatProvider;
import com.ffsupver.createheat.compat.iceAndFire.IceAndFire;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.registry.IafRegistryKeys;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record DragonHeater(DragonType dragonType, StageToHeatProviderFunc heatProviderByStage) {
    public static final Codec<IntFunctionFactory> INT_CODEC = Codec.lazyInitialized(() -> Codec.STRING.comapFlatMap(DragonHeater::parseExpression, DragonHeater::expressionToString));
    public static Codec<DragonHeater> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("dragon_type").forGetter(d -> IafRegistries.DRAGON_TYPE.getKey((Object)d.dragonType).toString()), (App)INT_CODEC.fieldOf("heat_per_tick").forGetter(d -> d.heatProviderByStage.heatPerTickProvider), (App)INT_CODEC.fieldOf("super_heat_count").forGetter(d -> d.heatProviderByStage.superHeatCountProvider)).apply((Applicative)i, (t, h, s) -> {
        ResourceKey typeResourceKey = ResourceKey.create((ResourceKey)IafRegistryKeys.DRAGON_TYPE, (ResourceLocation)ResourceLocation.parse((String)t));
        DragonType type = (DragonType)IafRegistries.DRAGON_TYPE.get(typeResourceKey);
        DragonHeater result = new DragonHeater(type, new StageToHeatProviderFunc((IntFunctionFactory)h, (IntFunctionFactory)s));
        CreateHeat.LOGGER.info("Register dragon heater {} with type:{}", (Object)result, t);
        return result;
    }));
    public static HeatProvider NO_HEAT_PROVIDER = new DragonHeatProvider(0, 0);

    public static Optional<Holder.Reference<DragonHeater>> getFromDragonType(RegistryAccess registryAccess, DragonType dragonType) {
        List<Holder.Reference> dragonHeaterList = registryAccess.lookupOrThrow(IceAndFire.DRAGON_HEATER).listElements().filter(hR -> {
            if (((DragonHeater)hR.value()).dragonType == null) {
                CreateHeat.LOGGER.error("[DragonHeater]find null dragon type {} ; Check you datapack createheat/dragon_heater", hR);
                return false;
            }
            return true;
        }).filter(hR -> ((DragonHeater)hR.value()).dragonType.equals((Object)dragonType)).toList();
        return dragonHeaterList.isEmpty() ? Optional.empty() : Optional.of(dragonHeaterList.getLast());
    }

    private static String expressionToString(IntFunctionFactory expression) {
        if (expression instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)expression;
            return String.valueOf(constant.value());
        }
        if (expression instanceof StageExpression) {
            return "stage";
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            return "(" + DragonHeater.expressionToString(binary.left()) + binary.operator().getSymbol() + DragonHeater.expressionToString(binary.right()) + ")";
        }
        throw new IllegalArgumentException("Unknown expression type: " + String.valueOf(expression.getClass()) + " exp=" + String.valueOf(expression) + " 1->" + expression.apply(1) + " 2->" + expression.apply(2));
    }

    private static DataResult<IntFunctionFactory> parseExpression(String expression) {
        try {
            IntFunctionFactory expr = DragonHeater.parseExpressionRecursive(expression.trim());
            return DataResult.success((Object)expr);
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression '" + expression + "': " + e.getMessage());
        }
    }

    private static IntFunctionFactory parseExpressionRecursive(String expr) {
        if ("stage".equals(expr = expr.trim())) {
            return new StageExpression();
        }
        try {
            int value = Integer.parseInt(expr);
            return new ConstantExpression(value);
        }
        catch (NumberFormatException value) {
            String[] operators;
            if (expr.startsWith("(") && expr.endsWith(")")) {
                return DragonHeater.parseExpressionRecursive(expr.substring(1, expr.length() - 1));
            }
            for (String op : operators = new String[]{"+", "-", "*", "/"}) {
                int index = DragonHeater.findOperatorIndex(expr, op);
                if (index == -1) continue;
                IntFunctionFactory left = DragonHeater.parseExpressionRecursive(expr.substring(0, index));
                IntFunctionFactory right = DragonHeater.parseExpressionRecursive(expr.substring(index + op.length()));
                return new BinaryExpression(left, right, BinaryExpression.Operator.fromSymbol(op));
            }
            throw new IllegalArgumentException("Invalid expression: " + expr);
        }
    }

    private static int findOperatorIndex(String expr, String operator) {
        int parenCount = 0;
        for (int i = 0; i < expr.length(); ++i) {
            char c = expr.charAt(i);
            if (c == '(') {
                ++parenCount;
                continue;
            }
            if (c == ')') {
                --parenCount;
                continue;
            }
            if (parenCount != 0 || !expr.startsWith(operator, i)) continue;
            return i;
        }
        return -1;
    }

    public record StageToHeatProviderFunc(IntFunctionFactory heatPerTickProvider, IntFunctionFactory superHeatCountProvider) {
        public HeatProvider apply(int stage) {
            return new DragonHeatProvider(this.heatPerTickProvider.apply(stage), this.superHeatCountProvider.apply(stage));
        }
    }

    public record ConstantExpression(int value) implements IntFunctionFactory
    {
        @Override
        public int apply(int stage) {
            return this.value;
        }

        @Override
        @NotNull
        public String toString() {
            return "constant:" + this.value;
        }
    }

    public record StageExpression() implements IntFunctionFactory
    {
        @Override
        public int apply(int stage) {
            return stage;
        }

        @Override
        @NotNull
        public String toString() {
            return "stage";
        }
    }

    public record BinaryExpression(IntFunctionFactory left, IntFunctionFactory right, Operator operator) implements IntFunctionFactory
    {
        @Override
        public int apply(int stage) {
            int leftVal = this.left.apply(stage);
            int rightVal = this.right.apply(stage);
            return this.operator.apply(leftVal, rightVal);
        }

        @Override
        public String toString() {
            return "BinaryExpression{" + this.left.toString() + " " + this.operator.symbol + " " + this.right.toString() + "}";
        }

        public static enum Operator {
            ADD("+", (a, b) -> a + b),
            SUBTRACT("-", (a, b) -> a - b),
            MULTIPLY("*", (a, b) -> a * b),
            DIVIDE("/", (a, b) -> {
                if (b == 0) {
                    throw new ArithmeticException("Division by zero");
                }
                return a / b;
            });

            private final String symbol;
            private final BinaryOperator<Integer> operation;

            private Operator(String symbol, BinaryOperator<Integer> operation) {
                this.symbol = symbol;
                this.operation = operation;
            }

            public int apply(int a, int b) {
                return (Integer)this.operation.apply(a, b);
            }

            public String getSymbol() {
                return this.symbol;
            }

            public static Operator fromSymbol(String symbol) {
                for (Operator op : Operator.values()) {
                    if (!op.symbol.equals(symbol)) continue;
                    return op;
                }
                throw new IllegalArgumentException("Unknown operator: " + symbol);
            }
        }
    }

    @FunctionalInterface
    private static interface IntFunctionFactory {
        public int apply(int var1);
    }

    private static class DragonHeatProvider
    implements HeatProvider {
        private final int heatPerTick;
        private final int superHeatCount;

        private DragonHeatProvider(int heatPerTick, int superHeatCount) {
            this.heatPerTick = heatPerTick;
            this.superHeatCount = superHeatCount;
        }

        @Override
        public int getHeatPerTick() {
            return this.heatPerTick;
        }

        @Override
        public int getSupperHeatCount() {
            return this.superHeatCount;
        }

        public String toString() {
            return "DragonHeatProvider:" + this.heatPerTick + "h/s" + this.superHeatCount;
        }
    }
}

