/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block;

import com.ffsupver.createheat.util.BlockUtil;
import com.ffsupver.createheat.util.NbtUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ConnectableBlockEntity<T extends ConnectableBlockEntity<T>>
extends SmartBlockEntity {
    protected boolean isController;
    private BlockPos controllerPos;
    protected final Set<BlockPos> connectedBlocks = new HashSet<BlockPos>();

    public ConnectableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.controllerPos = this.getBlockPos();
    }

    public abstract boolean canConnect(ConnectableBlockEntity<?> var1);

    protected abstract T castToSubclass();

    protected void connectedNewBlock(BlockPos newPos, ConnectableBlockEntity<?> oldBlockEntity) {
    }

    protected void mergeController(BlockPos oldControllerPos, ConnectableBlockEntity<?> oldControllerEntity, BlockPos newControllerPos, ConnectableBlockEntity<?> newControllerEntity) {
    }

    protected void switchToNewControllerWhenDestroy(BlockPos newPos, ConnectableBlockEntity<?> newControllerEntity) {
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.putBoolean("is_controller", this.isController);
        if (this.isController) {
            tag.put("connected", (Tag)NbtUtil.writeBlockPosToNbtList(this.connectedBlocks));
        } else {
            tag.put("controller", NbtUtils.writeBlockPos((BlockPos)this.controllerPos));
        }
        super.write(tag, registries, clientPacket);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.isController = tag.getBoolean("is_controller");
        if (this.isController) {
            this.connectedBlocks.clear();
            this.connectedBlocks.addAll(NbtUtil.readBlockPosFromNbtList(tag.getList("connected", 10)));
        } else {
            this.controllerPos = NBTHelper.readBlockPos((CompoundTag)tag, (String)"controller");
        }
        super.read(tag, registries, clientPacket);
    }

    public void checkNeighbour() {
        if (!this.isController) {
            AtomicBoolean foundConnect = new AtomicBoolean(false);
            BlockUtil.AllDirectionOf(this.getBlockPos(), checkPos -> {
                ConnectableBlockEntity neighbourEntity;
                BlockEntity patt0$temp = this.getLevel().getBlockEntity(checkPos);
                if (patt0$temp instanceof ConnectableBlockEntity && this.canConnect(neighbourEntity = (ConnectableBlockEntity)patt0$temp)) {
                    T controllerEntity;
                    this.isController = false;
                    if (!foundConnect.get()) {
                        this.controllerPos = neighbourEntity.getControllerPos();
                        foundConnect.set(true);
                    }
                    if ((controllerEntity = this.getControllerEntity()) != null) {
                        ((ConnectableBlockEntity)((Object)((Object)controllerEntity))).addConnectedPos(this.getBlockPos());
                        if (!neighbourEntity.getControllerPos().equals((Object)this.controllerPos)) {
                            if (neighbourEntity.getControllerEntity() != null) {
                                this.mergeController(neighbourEntity.getControllerPos(), (ConnectableBlockEntity<?>)((Object)((Object)neighbourEntity.getControllerEntity())), this.controllerPos, (ConnectableBlockEntity<?>)((Object)((Object)controllerEntity)));
                                ((ConnectableBlockEntity)((Object)((Object)neighbourEntity.getControllerEntity()))).isController = false;
                            }
                            ((ConnectableBlockEntity)((Object)((Object)controllerEntity))).walkAllBlocks(null);
                        }
                    }
                }
            });
            if (!foundConnect.get()) {
                this.isController = true;
                this.controllerPos = this.getBlockPos();
                this.addConnectedPos(this.getBlockPos());
            }
        }
    }

    public void destroy() {
        if (this.isController()) {
            for (BlockPos pos : this.connectedBlocks) {
                ConnectableBlockEntity connectableBlockEntity;
                BlockEntity blockEntity;
                if (pos.equals((Object)this.getBlockPos()) || !((blockEntity = this.getLevel().getBlockEntity(pos)) instanceof ConnectableBlockEntity) || !(connectableBlockEntity = (ConnectableBlockEntity)blockEntity).getControllerPos().equals((Object)this.getBlockPos())) continue;
                connectableBlockEntity.isController = true;
                connectableBlockEntity.walkAllBlocks(this.getBlockPos());
                this.switchToNewControllerWhenDestroy(pos, connectableBlockEntity);
            }
        } else {
            BlockEntity blockEntity = this.getLevel().getBlockEntity(this.controllerPos);
            if (blockEntity instanceof ConnectableBlockEntity) {
                ConnectableBlockEntity connectableBlockEntity = (ConnectableBlockEntity)blockEntity;
                connectableBlockEntity.walkAllBlocks(this.getBlockPos());
            }
        }
        super.destroy();
    }

    public void walkAllBlocks(BlockPos exceptFor) {
        Set<BlockPos> oldBlocks = Set.copyOf(this.connectedBlocks);
        this.connectedBlocks.clear();
        BlockUtil.walkAllBlocks(this.getBlockPos(), this.connectedBlocks, pos -> {
            ConnectableBlockEntity connectableBlockEntity;
            BlockEntity patt0$temp;
            if (!pos.equals((Object)exceptFor) && (patt0$temp = this.getLevel().getBlockEntity(pos)) instanceof ConnectableBlockEntity && this.canConnect(connectableBlockEntity = (ConnectableBlockEntity)patt0$temp)) {
                this.connectedNewBlock((BlockPos)pos, connectableBlockEntity);
                connectableBlockEntity.controllerPos = this.getBlockPos();
                return true;
            }
            return false;
        });
        for (BlockPos pos2 : oldBlocks) {
            ConnectableBlockEntity connectableBlockEntity;
            BlockEntity blockEntity;
            if (this.connectedBlocks.contains(pos2) || !((blockEntity = this.getLevel().getBlockEntity(pos2)) instanceof ConnectableBlockEntity) || !this.canConnect(connectableBlockEntity = (ConnectableBlockEntity)blockEntity) || connectableBlockEntity.isController() || !connectableBlockEntity.getControllerPos().equals((Object)this.getBlockPos())) continue;
            connectableBlockEntity.isController = true;
            connectableBlockEntity.walkAllBlocks(exceptFor);
            this.switchToNewControllerWhenDestroy(pos2, connectableBlockEntity);
        }
        this.notifyUpdate();
    }

    public T getControllerEntity() {
        ConnectableBlockEntity<T> controllerEntity;
        BlockEntity blockEntity;
        if (this.isController) {
            return this.castToSubclass();
        }
        if (this.controllerPos != null && (blockEntity = this.getLevel().getBlockEntity(this.controllerPos)) instanceof ConnectableBlockEntity && this.canConnect(controllerEntity = (ConnectableBlockEntity<T>)blockEntity)) {
            return (T)((Object)(controllerEntity.isController() ? controllerEntity : null));
        }
        return null;
    }

    public void addConnectedPos(BlockPos pos) {
        this.connectedBlocks.add(pos);
    }

    public boolean isController() {
        return this.isController;
    }

    public BlockPos getControllerPos() {
        return this.isController ? this.getBlockPos() : this.controllerPos;
    }

    public Set<BlockPos> getConnectedBlocks() {
        return this.isController ? this.connectedBlocks : ((ConnectableBlockEntity)((Object)this.getControllerEntity())).getConnectedBlocks();
    }
}

