/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.Config;
import com.ffsupver.createheat.registries.CHSpriteShifts;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ThermalBlockCTBehaviour
extends ConnectedTextureBehaviour.Base {
    private static Map<BlockType, Map<BlazeBurnerBlock.HeatLevel, CTSpriteShiftEntry>> SHIFT_MAP = ThermalBlockCTBehaviour.thermalBlockShiftMap();
    private final BlockType type;

    public ThermalBlockCTBehaviour(int blockTypeOrder) {
        this.type = BlockType.values()[blockTypeOrder];
    }

    public boolean connectsTo(BlockState state, BlockState other, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face) {
        return super.connectsTo(state, other, reader, pos, otherPos, face) && state.hasProperty((Property)BlazeBurnerBlock.HEAT_LEVEL) && other.hasProperty((Property)BlazeBurnerBlock.HEAT_LEVEL) && ((BlazeBurnerBlock.HeatLevel)state.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL)).equals((Object)other.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL));
    }

    @Nullable
    public CTSpriteShiftEntry getShift(BlockState state, Direction direction, @Nullable TextureAtlasSprite sprite) {
        if (((Boolean)Config.CONNECT_BLOCK_TEXTURE.get()).booleanValue()) {
            return SHIFT_MAP.get((Object)this.type).get(state.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL));
        }
        return null;
    }

    private static Map<BlockType, Map<BlazeBurnerBlock.HeatLevel, CTSpriteShiftEntry>> thermalBlockShiftMap() {
        Map<BlazeBurnerBlock.HeatLevel, CTSpriteShiftEntry> thermalBlock = Map.of(BlazeBurnerBlock.HeatLevel.NONE, CHSpriteShifts.THERMAL_BLOCK_NONE, BlazeBurnerBlock.HeatLevel.KINDLED, CHSpriteShifts.THERMAL_BLOCK_KINDLED, BlazeBurnerBlock.HeatLevel.SMOULDERING, CHSpriteShifts.THERMAL_BLOCK_KINDLED, BlazeBurnerBlock.HeatLevel.FADING, CHSpriteShifts.THERMAL_BLOCK_KINDLED, BlazeBurnerBlock.HeatLevel.SEETHING, CHSpriteShifts.THERMAL_BLOCK_SEETHING);
        Map<BlazeBurnerBlock.HeatLevel, CTSpriteShiftEntry> smartThermalBlock = Map.of(BlazeBurnerBlock.HeatLevel.NONE, CHSpriteShifts.SMART_THERMAL_BLOCK_NONE, BlazeBurnerBlock.HeatLevel.KINDLED, CHSpriteShifts.SMART_THERMAL_BLOCK_KINDLED, BlazeBurnerBlock.HeatLevel.SMOULDERING, CHSpriteShifts.SMART_THERMAL_BLOCK_KINDLED, BlazeBurnerBlock.HeatLevel.FADING, CHSpriteShifts.SMART_THERMAL_BLOCK_KINDLED, BlazeBurnerBlock.HeatLevel.SEETHING, CHSpriteShifts.SMART_THERMAL_BLOCK_SEETHING);
        return Map.of(BlockType.BASE, thermalBlock, BlockType.SMART, smartThermalBlock);
    }

    protected static enum BlockType {
        BASE,
        SMART;

    }
}

