/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.CHTags;
import com.ffsupver.createheat.Config;
import com.ffsupver.createheat.api.CustomHeater;
import com.ffsupver.createheat.block.ConnectableBlockEntity;
import com.ffsupver.createheat.block.HeatProvider;
import com.ffsupver.createheat.block.HeatTransferProcesser;
import com.ffsupver.createheat.block.thermalBlock.HeatStorage;
import com.ffsupver.createheat.block.thermalBlock.StoneHeatStorage;
import com.ffsupver.createheat.block.tightCompressStone.TightCompressStoneEntity;
import com.ffsupver.createheat.registries.CHHeatTransferProcessers;
import com.ffsupver.createheat.util.BlockUtil;
import com.ffsupver.createheat.util.NbtUtil;
import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ThermalBlockEntityBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<ThermalBlockEntityBehaviour> TYPE = new BehaviourType();
    private int heat;
    public static final Supplier<Integer> MAX_HEAT = () -> 50 * (Integer)Config.HEAT_PER_FADING_BLAZE.get();
    private int cooldown = 0;
    public static final int MAX_COOLDOWN = 10;
    private final HeatStorage heatStorage = new HeatStorage(MAX_HEAT.get());
    private final ArrayList<BlockPos> stoneHeatStorages = new ArrayList();
    private final Map<BlockPos, HeatTransferProcesser> transferProcesserMap = new HashMap<BlockPos, HeatTransferProcesser>();
    private final HeatStorage displayHeatStorage = new HeatStorage(0);
    private final ConnectableBlockEntity<?> connectableBlockEntity;
    private final Predicate<ThermalBlockEntityBehaviour> canSuperHeat;
    private final Predicate<ThermalBlockEntityBehaviour> canHeat;

    public ThermalBlockEntityBehaviour(ConnectableBlockEntity<?> be, Predicate<ThermalBlockEntityBehaviour> canHeat, Predicate<ThermalBlockEntityBehaviour> canSuperHeat) {
        super(be);
        this.connectableBlockEntity = be;
        this.canHeat = canHeat;
        this.canSuperHeat = canSuperHeat;
    }

    public ThermalBlockEntityBehaviour(ConnectableBlockEntity<?> be) {
        this(be, null, null);
    }

    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.isController()) {
            tag.putInt("heat", this.heat);
            tag.putInt("cooldown", this.cooldown);
            tag.put("heat_storage", (Tag)this.heatStorage.toNbt());
            tag.put("shs", (Tag)NbtUtil.writeBlockPosToNbtList(this.stoneHeatStorages));
            tag.put("transfer_processers", (Tag)NbtUtil.writeMapToNbtList(this.transferProcesserMap, NbtUtil::blockPosToNbt, CHHeatTransferProcessers::toNbt));
            if (clientPacket) {
                tag.put("display_heat", (Tag)this.getAllHeatForDisplay().toNbt());
            }
        }
    }

    public void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.isController()) {
            this.heat = tag.getInt("heat");
            this.cooldown = tag.getInt("cooldown");
            this.heatStorage.fromNbt(tag.getCompound("heat_storage"));
            this.stoneHeatStorages.clear();
            this.stoneHeatStorages.addAll(NbtUtil.readBlockPosFromNbtList(tag.getList("shs", 10)));
            this.transferProcesserMap.clear();
            this.transferProcesserMap.putAll(NbtUtil.readMapFromNbtList(tag.getList("transfer_processers", 10), NbtUtil::blockPosFromNbt, CHHeatTransferProcessers::fromNbt));
            if (clientPacket) {
                this.displayHeatStorage.fromNbt(tag.getCompound("display_heat"));
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.isController()) {
            return;
        }
        if (this.cooldown < 0) {
            this.tickEveryConnectedBlock();
            this.cooldown = 10;
        } else {
            --this.cooldown;
        }
        this.transferProcesserMap.forEach((hTPPos, hTP) -> {
            if (hTP.shouldProcessEveryTick()) {
                int heatProvider = ThermalBlockEntityBehaviour.calculateHeatProvide(hTPPos, this, 1);
                hTP.acceptHeat(this.getLevel(), (BlockPos)hTPPos, heatProvider, 1);
            }
        });
    }

    public void tickEveryConnectedBlock() {
        if (this.getLevel().isClientSide()) {
            return;
        }
        int tickSkip = 10;
        Set connectedBlockList = this.getConnectedBlocks().stream().map(pos -> (ThermalBlockEntityBehaviour)BlockEntityBehaviour.get((BlockEntity)this.getLevel().getBlockEntity(pos), TYPE)).filter(Objects::nonNull).collect(Collectors.toSet());
        int lastHeat = this.heat;
        this.heat = 0;
        int lastHeatStored = this.heatStorage.getAmount();
        int superHeatCount = 0;
        boolean changeSHS = false;
        Iterator<BlockPos> sHSIterator = this.stoneHeatStorages.iterator();
        while (sHSIterator.hasNext()) {
            TightCompressStoneEntity sHS;
            BlockPos sHSController = sHSIterator.next();
            BlockEntity tightCSE = this.getLevel().getBlockEntity(sHSController);
            if (tightCSE instanceof TightCompressStoneEntity && (!(tightCSE instanceof TightCompressStoneEntity) || (sHS = (TightCompressStoneEntity)tightCSE).isController() && sHS.isConnect(this.getConnectedBlocks()))) continue;
            sHSIterator.remove();
            changeSHS = true;
        }
        List<BlockPos> heatTransferProcesserToRemove = this.transferProcesserMap.entrySet().stream().filter(e -> !((HeatTransferProcesser)e.getValue()).needHeat(this.getLevel(), (BlockPos)e.getKey(), null) || !BlockUtil.isConnect(this.getConnectedBlocks(), Set.of((BlockPos)e.getKey()))).map(Map.Entry::getKey).toList();
        heatTransferProcesserToRemove.forEach(blockPos -> {
            this.transferProcesserMap.get(blockPos).onControllerRemove();
            this.transferProcesserMap.remove(blockPos);
        });
        for (ThermalBlockEntityBehaviour thermalBlockEntity : connectedBlockList) {
            if (thermalBlockEntity.getControllerEntity() == null) continue;
            HeatData heatBelow = thermalBlockEntity.genHeat();
            this.heat += heatBelow.heat * tickSkip;
            superHeatCount += heatBelow.superHeatCount;
            BlockUtil.AllDirectionOf(thermalBlockEntity.getBlockPos(), (checkPos, f) -> {
                TightCompressStoneEntity sHS;
                BlockPos sHSPosToAdd;
                if (this.transferProcesserMap.containsKey(checkPos)) {
                    return;
                }
                Optional<HeatTransferProcesser> transferProcesserOp = CHHeatTransferProcessers.findProcesser(this.getLevel(), checkPos, f);
                transferProcesserOp.ifPresent(hTP -> this.transferProcesserMap.putIfAbsent((BlockPos)checkPos, (HeatTransferProcesser)hTP));
                BlockEntity patt0$temp = this.getLevel().getBlockEntity(checkPos);
                if (patt0$temp instanceof TightCompressStoneEntity && !this.stoneHeatStorages.contains(sHSPosToAdd = (sHS = (TightCompressStoneEntity)patt0$temp).getControllerPos())) {
                    this.stoneHeatStorages.add(sHSPosToAdd);
                }
            });
        }
        boolean usingHeater = this.heat > 0;
        int superHeatCountFromSHS = this.releaseHeat();
        int superHeatCountFromHeater = superHeatCount;
        superHeatCount += superHeatCountFromSHS;
        for (ThermalBlockEntityBehaviour thermalBlockEntity : connectedBlockList) {
            if (thermalBlockEntity.getControllerEntity() == null) continue;
            CostHeatResult costHeatResult = thermalBlockEntity.costHeat(this.heat, tickSkip, superHeatCount);
            this.heat = costHeatResult.heat;
            superHeatCount = costHeatResult.superHeatCount;
        }
        this.transferProcesserMap.forEach((hTPPos, hTP) -> {
            if (!hTP.shouldProcessEveryTick()) {
                int heatProvide = ThermalBlockEntityBehaviour.calculateHeatProvide(hTPPos, this, tickSkip);
                hTP.acceptHeat(this.getLevel(), (BlockPos)hTPPos, heatProvide, tickSkip);
            }
        });
        this.storageHeat(superHeatCountFromHeater, superHeatCount, usingHeater);
        if (changeSHS || this.heat != lastHeat || lastHeatStored != this.heatStorage.getAmount()) {
            this.sendData();
        }
    }

    private HeatData genHeat() {
        BlockPos belowPos = this.getBlockPos().below();
        if (this.getControllerEntity().getConnectedBlocks().contains(belowPos)) {
            return new HeatData(0, 0);
        }
        Optional<Holder.Reference<CustomHeater>> customHeatOp = CustomHeater.getFromBlockState(this.getLevel().registryAccess(), this.getLevel().getBlockState(belowPos));
        BlockEntity blockEntity = this.getLevel().getBlockEntity(belowPos);
        if (blockEntity instanceof HeatProvider) {
            HeatProvider provider = (HeatProvider)blockEntity;
            return new HeatData(provider.getHeatPerTick(), provider.getSupperHeatCount());
        }
        if (customHeatOp.isPresent()) {
            CustomHeater customHeater = (CustomHeater)customHeatOp.get().value();
            return new HeatData(customHeater.heatPerTick(), customHeater.superHeatCount());
        }
        BlazeBurnerBlock.HeatLevel heatLevelB = this.getHeatLevel(belowPos);
        int boilHeat = (int)BoilerHeater.findHeat((Level)this.getLevel(), (BlockPos)this.getBlockPos().below(), (BlockState)this.getLevel().getBlockState(this.getBlockPos().below())) + 1;
        int result = Math.max(ThermalBlockEntityBehaviour.getHeatPerTick(heatLevelB), boilHeat);
        if (!((Boolean)Config.ALLOW_PASSIVE_HEAT.get()).booleanValue()) {
            result = result == 1 ? 0 : result;
        }
        return new HeatData(result, result >= 3 ? 1 : 0);
    }

    private CostHeatResult costHeat(int heat, int tickSkip, int superHeat) {
        boolean canSuperHeat;
        if (!this.needToHeat()) {
            this.setBlockHeat(BlazeBurnerBlock.HeatLevel.NONE);
            return new CostHeatResult(heat, superHeat);
        }
        boolean bl = canSuperHeat = this.onCanSuperHeaTest() && ((Boolean)Config.ALLOW_GENERATE_SUPER_HEAT.get() != false || superHeat > 0);
        if (canSuperHeat && heat >= ThermalBlockEntityBehaviour.calculateHeatCost(tickSkip, BlazeBurnerBlock.HeatLevel.SEETHING)) {
            if (this.needToHeatUp(BlazeBurnerBlock.HeatLevel.SEETHING)) {
                this.setBlockHeat(BlazeBurnerBlock.HeatLevel.SEETHING);
            }
        } else if (heat >= ThermalBlockEntityBehaviour.calculateHeatCost(tickSkip, BlazeBurnerBlock.HeatLevel.KINDLED)) {
            if (this.needToHeatUp(BlazeBurnerBlock.HeatLevel.KINDLED) || this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING)) {
                this.setBlockHeat(BlazeBurnerBlock.HeatLevel.KINDLED);
            }
        } else {
            this.setBlockHeat(BlazeBurnerBlock.HeatLevel.NONE);
        }
        if (!((Boolean)Config.ALLOW_SUPER_HEAT_REPRODUCE.get()).booleanValue() && this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING)) {
            --superHeat;
        }
        return new CostHeatResult(heat - ThermalBlockEntityBehaviour.calculateHeatCost(tickSkip, this.getHeatLevel()), superHeat);
    }

    private void storageHeat(int superHeatCount, int superCountLeft, boolean usingHeater) {
        if (this.heat > 0) {
            int left = this.heat;
            for (BlockPos stoneHeatStoragePos : this.stoneHeatStorages) {
                BlockEntity blockEntity = this.getLevel().getBlockEntity(stoneHeatStoragePos);
                if (!(blockEntity instanceof TightCompressStoneEntity)) continue;
                TightCompressStoneEntity stoneHeatStorage = (TightCompressStoneEntity)blockEntity;
                if (left > 0) {
                    int inserted = stoneHeatStorage.insert(left);
                    left -= inserted;
                }
                if (((Boolean)Config.ALLOW_GENERATE_SUPER_HEAT.get()).booleanValue()) continue;
                superHeatCount = stoneHeatStorage.addSuperHeatCount(superCountLeft, superHeatCount, usingHeater, this.getControllerPos());
            }
            if (left > 0) {
                this.heatStorage.insert(left);
            }
        }
    }

    private int releaseHeat() {
        int superHeatCount = 0;
        if (this.heat <= 0) {
            for (BlockPos stoneHeatStoragePos : this.stoneHeatStorages) {
                BlockEntity blockEntity = this.getLevel().getBlockEntity(stoneHeatStoragePos);
                if (!(blockEntity instanceof TightCompressStoneEntity)) continue;
                TightCompressStoneEntity stoneHeatStorage = (TightCompressStoneEntity)blockEntity;
                int need = this.heatStorage.getCapacity() - this.heatStorage.getAmount();
                if (need > 0) {
                    int toExtract = stoneHeatStorage.extract(need, true);
                    toExtract = this.heatStorage.insert(toExtract);
                    stoneHeatStorage.extract(toExtract, false);
                }
                if (((Boolean)Config.ALLOW_GENERATE_SUPER_HEAT.get()).booleanValue()) continue;
                superHeatCount += stoneHeatStorage.releaseSuperHeatCount(this.getControllerPos());
            }
            this.heat += this.heatStorage.extract(this.heatStorage.getAmount(), false);
        }
        return superHeatCount;
    }

    private boolean needToHeatUp(BlazeBurnerBlock.HeatLevel heatLevel) {
        return this.needToHeat() && (this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.NONE) || heatLevel.equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING) && !this.getHeatLevel().equals((Object)BlazeBurnerBlock.HeatLevel.SEETHING));
    }

    private boolean needToHeat() {
        if (!this.onCanHeatTest()) {
            return false;
        }
        AtomicBoolean findProcesser = new AtomicBoolean(false);
        List<BlockPos> transferProcesserKeys = List.copyOf(this.getControllerEntity().transferProcesserMap.keySet());
        BlockUtil.AllDirectionOf(this.getBlockPos(), blockPos -> {
            if (!findProcesser.get()) {
                findProcesser.set(transferProcesserKeys.contains(blockPos));
            }
        });
        return this.needToHeatAbove() || findProcesser.get();
    }

    private boolean onCanHeatTest() {
        return ThermalBlockEntityBehaviour.onTest(this.canHeat, this);
    }

    private boolean onCanSuperHeaTest() {
        return ThermalBlockEntityBehaviour.onTest(this.canSuperHeat, this);
    }

    public Optional<HeatTransferProcesser> getHeatTransferProcesserByOther(BlockPos pos) {
        return Optional.ofNullable(this.getControllerEntity().transferProcesserMap.get(pos));
    }

    /*
     * Unable to fully structure code
     */
    public boolean needToHeatAbove() {
        needToHeatAbove = this.getLevel().getBlockState(this.getBlockPos().above()).is(CHTags.BlockTag.SHOULD_HEAT);
        var4_2 = this.getLevel().getBlockEntity(this.getBlockPos().above());
        if (!(var4_2 instanceof FluidTankBlockEntity)) ** GOTO lbl-1000
        fluidTankBlockEntity = (FluidTankBlockEntity)var4_2;
        if (fluidTankBlockEntity.getControllerBE().boiler.attachedEngines > 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        needToHeatBoiler = v0;
        return needToHeatAbove != false || needToHeatBoiler != false;
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevel(BlockPos pos) {
        BlockState blockState = this.getLevel().getBlockState(pos);
        return blockState.hasProperty((Property)BlazeBurnerBlock.HEAT_LEVEL) ? (BlazeBurnerBlock.HeatLevel)blockState.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL) : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevel() {
        return (BlazeBurnerBlock.HeatLevel)this.getBlockState().getValue((Property)BlazeBurnerBlock.HEAT_LEVEL);
    }

    public void setBlockHeat(BlazeBurnerBlock.HeatLevel heatLevel) {
        this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)heatLevel), 3);
        this.notifyUpdate();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HeatStorage heatStorageForDisplay;
        ThermalBlockEntityBehaviour controllerEntity = this.getControllerEntity();
        if (controllerEntity != null && (heatStorageForDisplay = controllerEntity.displayHeatStorage) != null) {
            tooltip.add((Component)Component.literal((String)Strings.repeat((char)' ', (int)4)).append((Component)Component.translatable((String)"createheat.gui.goggles.heat_amount", (Object[])new Object[]{heatStorageForDisplay.getAmount(), heatStorageForDisplay.getCapacity()})));
            tooltip.add((Component)Component.literal((String)Strings.repeat((char)' ', (int)4)).append((Component)Component.translatable((String)"createheat.gui.goggles.heat_remain", (Object[])new Object[]{this.getControllerEntity().heat / 10})));
            return true;
        }
        return false;
    }

    protected void mergeController(BlockPos oldControllerPos, ThermalBlockEntityBehaviour oldControllerEntity, BlockPos newControllerPos, ThermalBlockEntityBehaviour newControllerEntity) {
        oldControllerEntity.switchStoneHeatStorageToNew(newControllerPos, newControllerEntity, true);
        oldControllerEntity.transferProcesserMap.forEach((p, hTP) -> hTP.onControllerRemove());
    }

    protected void switchToNewControllerWhenDestroy(BlockPos newPos, ThermalBlockEntityBehaviour newControllerEntity) {
        this.switchStoneHeatStorageToNew(newPos, newControllerEntity, false);
    }

    public void destroy() {
        this.transferProcesserMap.forEach((b, h) -> h.onControllerRemove());
        super.destroy();
    }

    private void switchStoneHeatStorageToNew(BlockPos newControllerPos, ThermalBlockEntityBehaviour newControllerEntity, boolean merge) {
        Iterator<BlockPos> shsPosIt = this.stoneHeatStorages.iterator();
        while (shsPosIt.hasNext()) {
            BlockPos shsPos = shsPosIt.next();
            BlockEntity blockEntity = this.getLevel().getBlockEntity(shsPos);
            if (!(blockEntity instanceof TightCompressStoneEntity)) continue;
            TightCompressStoneEntity sHSEntity = (TightCompressStoneEntity)blockEntity;
            if (merge) {
                sHSEntity.switchTControllerTo(this.getControllerPos(), newControllerPos);
                shsPosIt.remove();
                continue;
            }
            if (sHSEntity.isConnect(this.getConnectedBlocks()) && !this.isController() || !sHSEntity.isConnect(newControllerEntity.getConnectedBlocks())) continue;
            sHSEntity.switchTControllerTo(this.getControllerPos(), newControllerPos);
            shsPosIt.remove();
        }
    }

    public void calculateHeatStorage() {
        this.heatStorage.setCapacity(this.getConnectedBlocks().size() * MAX_HEAT.get());
    }

    public HeatStorage getAllHeatForDisplay() {
        HeatStorage result = new HeatStorage(0);
        for (BlockPos sHSPos : this.stoneHeatStorages) {
            BlockEntity blockEntity = this.getLevel().getBlockEntity(sHSPos);
            if (!(blockEntity instanceof TightCompressStoneEntity)) continue;
            TightCompressStoneEntity sHS = (TightCompressStoneEntity)blockEntity;
            StoneHeatStorage hs = sHS.getStoneHeatStorage();
            result.setCapacity(result.getCapacity() + hs.getCapacity());
            result.insert(hs.getAmount());
        }
        result.setCapacity(result.getCapacity() + this.heatStorage.getCapacity());
        result.insert(this.heatStorage.getAmount());
        return result;
    }

    public HeatStorage getHeatStorage() {
        if (this.isController()) {
            return this.heatStorage;
        }
        return this.getControllerEntity().getHeatStorage();
    }

    private static int calculateHeatProvide(BlockPos cPos, ThermalBlockEntityBehaviour controller, int tickSkip) {
        AtomicInteger heatAccept = new AtomicInteger();
        BlockUtil.AllDirectionOf(cPos, pos -> {
            if (controller.getConnectedBlocks().contains(pos)) {
                BlazeBurnerBlock.HeatLevel heatLevel = controller.getHeatLevel((BlockPos)pos);
                heatAccept.addAndGet(ThermalBlockEntityBehaviour.calculateHeatCost(tickSkip, heatLevel));
            }
        });
        return heatAccept.get();
    }

    public int getHeat() {
        return this.heat;
    }

    public boolean isConnectTo(StoneHeatStorage shs) {
        return shs.isConnect(this.getControllerEntity().getConnectedBlocks());
    }

    public int getBlockSize() {
        return this.getConnectedBlocks().size();
    }

    private boolean isController() {
        return this.connectableBlockEntity.isController();
    }

    private BlockPos getControllerPos() {
        return this.connectableBlockEntity.getControllerPos();
    }

    private ThermalBlockEntityBehaviour getControllerEntity() {
        return (ThermalBlockEntityBehaviour)BlockEntityBehaviour.get(this.connectableBlockEntity.getControllerEntity(), TYPE);
    }

    private Set<BlockPos> getConnectedBlocks() {
        return this.connectableBlockEntity.getConnectedBlocks();
    }

    private Level getLevel() {
        return this.connectableBlockEntity.getLevel();
    }

    private BlockPos getBlockPos() {
        return this.connectableBlockEntity.getBlockPos();
    }

    private BlockState getBlockState() {
        return this.connectableBlockEntity.getBlockState();
    }

    public void sendData() {
        this.connectableBlockEntity.sendData();
    }

    private void notifyUpdate() {
        this.connectableBlockEntity.notifyUpdate();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static int calculateHeatCost(int tickSkip, BlazeBurnerBlock.HeatLevel heatLevel) {
        return tickSkip * ThermalBlockEntityBehaviour.getHeatPerTick(heatLevel);
    }

    public static int getHeatPerTick(BlazeBurnerBlock.HeatLevel heatLevel) {
        return switch (heatLevel) {
            default -> throw new MatchException(null, null);
            case BlazeBurnerBlock.HeatLevel.NONE -> 0;
            case BlazeBurnerBlock.HeatLevel.SMOULDERING -> 1;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> (Integer)Config.HEAT_PER_FADING_BLAZE.get();
            case BlazeBurnerBlock.HeatLevel.SEETHING -> (Integer)Config.HEAT_PER_SEETHING_BLAZE.get();
        };
    }

    public static ThermalBlockEntityBehaviour getFromCBE(ConnectableBlockEntity<?> be) {
        return (ThermalBlockEntityBehaviour)be.getBehaviour(TYPE);
    }

    public static boolean canConnect(ConnectableBlockEntity<?> toCheck) {
        return ThermalBlockEntityBehaviour.getFromCBE(toCheck) != null;
    }

    private static boolean onTest(Predicate<ThermalBlockEntityBehaviour> test, ThermalBlockEntityBehaviour behaviour) {
        if (test == null) {
            return true;
        }
        return test.test(behaviour);
    }

    private record HeatData(int heat, int superHeatCount) {
    }

    private record CostHeatResult(int heat, int superHeatCount) {
    }
}

