/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.tightCompressStone;

import com.ffsupver.createheat.block.tightCompressStone.ConnectableBlock;
import com.ffsupver.createheat.block.tightCompressStone.TightCompressStoneEntity;
import com.ffsupver.createheat.registries.CHBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.extensions.IBlockExtension;
import org.jetbrains.annotations.NotNull;

public class TightCompressStone
extends ConnectableBlock<TightCompressStoneEntity>
implements IBlockExtension {
    public static final Property<Heat> HEAT = EnumProperty.create((String)"heat", Heat.class);

    public TightCompressStone(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HEAT, (Comparable)((Object)Heat.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HEAT});
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return ((Heat)((Object)state.getValue(HEAT))).getLight();
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!((Heat)((Object)state.getValue(HEAT))).equals((Object)Heat.NONE) && !entity.isSteppingCarefully() && entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().hotFloor(), ((Heat)((Object)state.getValue(HEAT))).equals((Object)Heat.REGULAR_HEAT) ? 1.0f : 2.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Heat)((Object)state.getValue(HEAT))).equals((Object)Heat.NONE) && random.nextInt(2) == 0) {
            Direction direction = Direction.getRandom((RandomSource)random);
            BlockPos particlePos = pos.relative(direction);
            BlockState particlePosState = level.getBlockState(particlePos);
            if (!state.canOcclude() || !particlePosState.isFaceSturdy((BlockGetter)level, particlePos, direction.getOpposite())) {
                double d0 = direction.getStepX() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepX() * 0.6;
                double d1 = direction.getStepY() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepY() * 0.6;
                double d2 = direction.getStepZ() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepZ() * 0.6;
                SimpleParticleType particleOptions = ((Heat)((Object)state.getValue(HEAT))).equals((Object)Heat.REGULAR_HEAT) ? ParticleTypes.DRIPPING_LAVA : ParticleTypes.SOUL_FIRE_FLAME;
                level.addParticle((ParticleOptions)particleOptions, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public Class<TightCompressStoneEntity> getBlockEntityClass() {
        return TightCompressStoneEntity.class;
    }

    public BlockEntityType<? extends TightCompressStoneEntity> getBlockEntityType() {
        return (BlockEntityType)CHBlocks.TIGHT_COMPRESSED_STONE_ENTITY.get();
    }

    public boolean isBurning(BlockState state, BlockGetter level, BlockPos pos) {
        return !((Heat)((Object)state.getValue(HEAT))).equals((Object)Heat.NONE);
    }

    public static enum Heat implements StringRepresentable
    {
        NONE("none", 0),
        REGULAR_HEAT("regular_heat", 15),
        SUPER_HEAT("super_heat", 12);

        private final String name;
        private final int light;

        private Heat(String name, int light) {
            this.name = name;
            this.light = light;
        }

        public int getLight() {
            return this.light;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

