/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.compat;

import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.compat.CHModCompat;
import com.ffsupver.createheat.compat.coldSweat.ColdSweat;
import com.ffsupver.createheat.compat.iceAndFire.IceAndFire;
import com.ffsupver.createheat.compat.pneumaticcraft.Pneumaticcraft;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.ponder.api.registration.PonderSceneRegistrationHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class Mods {
    private static final Map<String, Supplier<CHModCompat>> MOD_SUPPLIERS = new HashMap<String, Supplier<CHModCompat>>();
    private static final Map<String, CHModCompat> MODS = new HashMap<String, CHModCompat>();
    private static boolean hasInit = false;

    private static void loadMods() {
        if (!hasInit) {
            MOD_SUPPLIERS.clear();
            Mods.addMod(ModIds.ICE_AND_FIRE, IceAndFire.class);
            Mods.addMod(ModIds.PNEUMATICCRAFT, Pneumaticcraft.class);
            Mods.addMod(ModIds.COLD_SWEAT, ColdSweat.class);
            MOD_SUPPLIERS.forEach(Mods::intiMod);
            hasInit = true;
        }
    }

    public static void init(IEventBus eventBus) {
        Mods.loadMods();
        Mods.executeIfLoad(chModCompat -> chModCompat.init(eventBus));
        eventBus.addListener(Mods::registerBoilerHeater);
    }

    public static void registerPonder(PonderSceneRegistrationHelper<ItemProviderEntry<?, ?>> HELPER) {
        Mods.loadMods();
        Mods.executeIfLoad(chModCompat -> chModCompat.registerPonder(HELPER));
    }

    private static void addMod(ModIds modId, Class<? extends CHModCompat> modCompatClass) {
        CreateHeat.LOGGER.info("[Mod Compat]{}:is {}!", (Object)modId.ModId, (Object)(Mods.isModLoad(modId.ModId) ? "loaded" : "not loaded"));
        if (Mods.isModLoad(modId.ModId)) {
            Supplier<CHModCompat> modCompatSupplier = () -> {
                try {
                    return (CHModCompat)modCompatClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    CreateHeat.LOGGER.error("[Mod Compat Fail]{}:{}", (Object)modId.ModId, (Object)e.getMessage());
                    throw new RuntimeException(e);
                }
            };
            MOD_SUPPLIERS.put(modId.ModId, modCompatSupplier);
        }
    }

    private static void intiMod(String modId, Supplier<CHModCompat> modCompatSupplier) {
        MODS.put(modId, modCompatSupplier.get());
    }

    private static boolean isModLoad(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static void addItemsToCreativeTab(BuildCreativeModeTabContentsEvent event, ResourceKey<CreativeModeTab> tabKey, ItemLike ... itemLikes) {
        if (event.getTabKey().equals(tabKey)) {
            Arrays.stream(itemLikes).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }

    private static void registerBoilerHeater(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> Mods.executeIfLoad(CHModCompat::registerBoilerHeater));
    }

    private static void executeIfLoad(Consumer<CHModCompat> runnable) {
        for (Map.Entry<String, CHModCompat> entry : MODS.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey())) continue;
            runnable.accept(entry.getValue());
        }
    }

    public static void executeIfModLoad(String modTd, Consumer<CHModCompat> runnable) {
        if (MODS.containsKey(modTd)) {
            runnable.accept(MODS.get(modTd));
        }
    }

    public static enum ModIds {
        ICE_AND_FIRE("iceandfire"),
        PNEUMATICCRAFT("pneumaticcraft"),
        COLD_SWEAT("cold_sweat");

        public final String ModId;

        private ModIds(String modId) {
            this.ModId = modId;
        }
    }
}

