/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.compat.jei.category;

import com.ffsupver.createheat.Config;
import com.ffsupver.createheat.block.thermalBlock.ThermalBlock;
import com.ffsupver.createheat.compat.jei.CreateHeatJEI;
import com.ffsupver.createheat.recipe.HeatRecipe;
import com.ffsupver.createheat.registries.CHBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class HeatCategory
implements IRecipeCategory<HeatRecipe> {
    private static final List<Vec3i> HEAT_POSITIONS = List.of(new Vec3i(0, 0, -1), new Vec3i(0, 1, 0), new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, 1), new Vec3i(0, -1, 0));
    public static final RecipeType<HeatRecipe> TYPE = CreateHeatJEI.recipeType("heat", HeatRecipe.class);

    public RecipeType<HeatRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"createheat.recipe.heat");
    }

    @Nullable
    public IDrawable getIcon() {
        return new ItemIcon(() -> ((ThermalBlock)((Object)((Object)CHBlocks.THERMAL_BLOCK.get()))).asItem().getDefaultInstance());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HeatRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT).setSlotName("input").setPosition(20, 100)).addIngredients((Ingredient)recipe.getIngredients().getFirst())).setStandardSlotBackground();
        BlockState outputBlock = recipe.getOutputBlock();
        ((IRecipeSlotBuilder)((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT).setPosition(217, 70)).addItemStack(outputBlock.getFluidState().isEmpty() ? outputBlock.getBlock().asItem().getDefaultInstance() : outputBlock.getFluidState().getType().getBucket().getDefaultInstance())).setOutputSlotBackground();
    }

    public int getWidth() {
        return 255;
    }

    public int getHeight() {
        return 128;
    }

    public void draw(HeatRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ItemStack stack;
        Item item;
        Optional itemStackOptional;
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        MutableComponent heatDec = Component.translatable((String)"createheat.recipe.heat.amount", (Object[])new Object[]{recipe.getMinHeatPerTick(), recipe.getHeatCost()});
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)heatDec, this.getWidth() / 2 - 20, 100, 0xFF0000);
        int scale = 32;
        int xOffsetInput = 40;
        int yOffsetInput = 70;
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        HeatCategory.translateBlock(xOffsetInput, yOffsetInput, matrixStack);
        Optional recipeSlotsViewOptional = recipeSlotsView.findSlotByName("input");
        if (recipeSlotsViewOptional.isPresent() && (itemStackOptional = ((IRecipeSlotView)recipeSlotsViewOptional.get()).getDisplayedItemStack()).isPresent() && (item = (stack = (ItemStack)itemStackOptional.get()).getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            HeatCategory.drawBlock(blockItem.getBlock().defaultBlockState(), 0, 0, 0, scale, guiGraphics);
        }
        HeatCategory.drawThermalBlockByHeat(recipe.getMinHeatPerTick(), (Integer)Config.HEAT_PER_FADING_BLAZE.get(), (Integer)Config.HEAT_PER_SEETHING_BLAZE.get(), scale, guiGraphics);
        matrixStack.popPose();
        int xOffsetOutput = 200;
        int yOffsetOutput = 50;
        matrixStack.pushPose();
        HeatCategory.translateBlock(xOffsetOutput, yOffsetOutput, matrixStack);
        HeatCategory.drawBlock(recipe.getOutputBlock(), 0, 0, 0, scale, guiGraphics);
        matrixStack.popPose();
    }

    private static void translateBlock(int xOffset, int yOffset, PoseStack matrixStack) {
        matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
    }

    private static void drawBlock(BlockState state, int x, int y, int z, int scale, GuiGraphics guiGraphics) {
        AnimatedKinetics.defaultBlockElement((BlockState)state).atLocal((double)x, (double)y, (double)z).scale((double)scale).render(guiGraphics);
    }

    private static BlockState thermalBlock(BlazeBurnerBlock.HeatLevel heatLevel) {
        return (BlockState)CHBlocks.THERMAL_BLOCK.getDefaultState().setValue((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)heatLevel);
    }

    private static void drawThermalBlockByHeat(int minHeat, int heatPerRegular, int heatPerSuper, int scale, GuiGraphics guiGraphics) {
        int left = minHeat;
        for (Vec3i pos : HEAT_POSITIONS) {
            boolean superH = left >= heatPerSuper;
            BlockState thermalBlock = HeatCategory.thermalBlock(superH ? BlazeBurnerBlock.HeatLevel.SEETHING : BlazeBurnerBlock.HeatLevel.KINDLED);
            HeatCategory.drawBlock(thermalBlock, pos.getX(), pos.getY(), pos.getZ(), scale, guiGraphics);
            if ((left -= superH ? heatPerSuper : heatPerRegular) > 0) continue;
            break;
        }
    }
}

