/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.recipe;

import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.block.ConnectableBlockEntity;
import com.ffsupver.createheat.block.HeatTransferProcesser;
import com.ffsupver.createheat.block.thermalBlock.ThermalBlockEntityBehaviour;
import com.ffsupver.createheat.recipe.HeatRecipe;
import com.ffsupver.createheat.registries.CHRecipes;
import com.ffsupver.createheat.util.BlockUtil;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HeatRecipeTransferProcesser
extends HeatTransferProcesser {
    public static final ResourceLocation TYPE = CreateHeat.asResource("heat_recipe");
    private boolean finished = false;
    private boolean removed = false;
    private boolean isMainProcesser = false;
    private int acceptedHeat = 0;
    private int totalHeat = 0;
    private BlockPos fr = null;
    private HeatRecipeTransferProcesser mainProcesser = null;

    public HeatRecipeTransferProcesser() {
        super(TYPE);
    }

    @Override
    public boolean needHeat(Level level, BlockPos checkPos, @Nullable Direction face) {
        Optional<RecipeHolder<HeatRecipe>> optionalRH = HeatRecipeTransferProcesser.getRecipe(level, checkPos);
        if (optionalRH.isPresent()) {
            if (face == null) {
                return !this.finished;
            }
            ConnectableBlockEntity<?> thBlockAttach = HeatRecipeTransferProcesser.getAttachThermalBlock(level, checkPos, face);
            AtomicReference oHRP = new AtomicReference(Optional.empty());
            BlockUtil.AllDirectionOf(checkPos, (checkControllerPos, f) -> {
                HeatTransferProcesser patt1$temp;
                Optional<HeatTransferProcesser> otherHTP;
                ConnectableBlockEntity connectableBlockEntity;
                ThermalBlockEntityBehaviour otherTE;
                BlockEntity patt0$temp;
                if (!f.equals((Object)face.getOpposite()) && (patt0$temp = level.getBlockEntity(checkControllerPos)) instanceof ConnectableBlockEntity && (otherTE = (ThermalBlockEntityBehaviour)BlockEntityBehaviour.get((BlockEntity)(connectableBlockEntity = (ConnectableBlockEntity)patt0$temp), ThermalBlockEntityBehaviour.TYPE)) != null && !connectableBlockEntity.getControllerPos().equals((Object)thBlockAttach.getControllerPos()) && (otherHTP = otherTE.getHeatTransferProcesserByOther(checkPos)).isPresent() && (patt1$temp = otherHTP.get()) instanceof HeatRecipeTransferProcesser) {
                    HeatRecipeTransferProcesser hRTP = (HeatRecipeTransferProcesser)patt1$temp;
                    if (hRTP.isMainProcesser) {
                        oHRP.set(otherHTP);
                    }
                }
            }, c -> {
                if (!((Optional)oHRP.get()).isPresent()) return false;
                Object patt0$temp = ((Optional)oHRP.get()).get();
                if (!(patt0$temp instanceof HeatRecipeTransferProcesser)) return false;
                HeatRecipeTransferProcesser hRTP = (HeatRecipeTransferProcesser)patt0$temp;
                if (!hRTP.isMainProcesser) return false;
                return true;
            });
            if (oHRP.get().isEmpty()) {
                this.isMainProcesser = true;
                this.mainProcesser = null;
            } else {
                Object t = oHRP.get().get();
                if (t instanceof HeatRecipeTransferProcesser) {
                    HeatRecipeTransferProcesser mainRecipeP = (HeatRecipeTransferProcesser)t;
                    this.mainProcesser = mainRecipeP.isMainProcesser ? mainRecipeP : mainRecipeP.mainProcesser;
                }
            }
            this.fr = checkPos.relative(face.getOpposite());
            return true;
        }
        return false;
    }

    @Override
    public void acceptHeat(Level level, BlockPos hTPPos, int heatProvide, int tickSkip) {
        if (this.isMainProcesser) {
            this.acceptHeatAsMainP(level, hTPPos, heatProvide, tickSkip);
        } else if (this.mainProcesser.removed) {
            if (this.mainProcesser.mainProcesser == null) {
                this.mainProcesser.switchToNew(this);
                this.acceptHeatAsMainP(level, hTPPos, heatProvide, tickSkip);
            } else {
                this.mainProcesser = this.mainProcesser.mainProcesser;
                this.mainProcesser.mainAcceptHeat(heatProvide);
            }
        } else {
            this.mainProcesser.mainAcceptHeat(heatProvide);
        }
    }

    private void mainAcceptHeat(int heat) {
        this.acceptedHeat += heat;
    }

    @Override
    public boolean shouldProcessEveryTick() {
        return false;
    }

    @Override
    public boolean shouldWriteAndReadFromNbt() {
        return this.isMainProcesser;
    }

    @Override
    public void onControllerRemove() {
        this.removed = true;
    }

    @Override
    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("total", this.totalHeat);
        nbt.putInt("accepted", this.acceptedHeat);
        nbt.putBoolean("is_main", this.isMainProcesser);
        return nbt;
    }

    @Override
    public void fromNbt(CompoundTag nbt) {
        this.totalHeat = nbt.getInt("total");
        this.acceptedHeat = nbt.getInt("accepted");
        this.isMainProcesser = nbt.getBoolean("is_main");
    }

    private void acceptHeatAsMainP(Level level, BlockPos hTPPos, int heatProvide, int tickSkip) {
        Optional<RecipeHolder<HeatRecipe>> optionalRH = HeatRecipeTransferProcesser.getRecipe(level, hTPPos);
        if (optionalRH.isPresent()) {
            HeatRecipe recipe = (HeatRecipe)optionalRH.get().value();
            this.acceptedHeat += heatProvide;
            if (this.acceptedHeat >= recipe.getMinHeatPerTick() * tickSkip) {
                this.totalHeat += this.acceptedHeat;
                if (this.totalHeat >= recipe.getHeatCost()) {
                    this.doneRecipe(level, recipe, hTPPos);
                }
            }
        }
        this.acceptedHeat = 0;
    }

    private void doneRecipe(Level level, HeatRecipe heatRecipe, BlockPos processPos) {
        BlockState outputState = heatRecipe.getOutputBlock();
        if (outputState.getFluidState().is(FluidTags.WATER) && level.dimensionType().ultraWarm()) {
            level.destroyBlock(processPos, false);
        } else {
            level.setBlock(processPos, heatRecipe.getOutputBlock(), 3);
        }
        this.finished = true;
    }

    private void switchToNew(HeatRecipeTransferProcesser newTransferP) {
        this.mainProcesser = newTransferP;
        newTransferP.isMainProcesser = true;
        newTransferP.mainProcesser = null;
        newTransferP.totalHeat = this.totalHeat;
        newTransferP.acceptedHeat = this.acceptedHeat;
    }

    private static ConnectableBlockEntity<?> getAttachThermalBlock(Level level, BlockPos transferProcesserPos, Direction face) {
        ConnectableBlockEntity connectableBlockEntity;
        BlockPos thBlockPos = transferProcesserPos.relative(face.getOpposite());
        BlockEntity blockEntity = level.getBlockEntity(thBlockPos);
        if (blockEntity instanceof ConnectableBlockEntity && BlockEntityBehaviour.get((BlockEntity)(connectableBlockEntity = (ConnectableBlockEntity)blockEntity), ThermalBlockEntityBehaviour.TYPE) != null) {
            return connectableBlockEntity;
        }
        return null;
    }

    private static Optional<RecipeHolder<HeatRecipe>> getRecipe(Level level, BlockPos checkPos) {
        BlockState checkState = level.getBlockState(checkPos);
        HeatRecipe.HeatRecipeTester tester = new HeatRecipe.HeatRecipeTester(checkState);
        return level.getRecipeManager().getRecipeFor((RecipeType)CHRecipes.HEAT_RECIPE.get(), (RecipeInput)tester, level);
    }
}

