/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.registries;

import com.ffsupver.createheat.CreateHeat;
import com.ffsupver.createheat.block.HeatTransferProcesser;
import com.ffsupver.createheat.recipe.HeatRecipeTransferProcesser;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class CHHeatTransferProcessers {
    private static final CreateRegistrate REGISTRATE = CreateHeat.registrate();
    public static final ResourceKey<Registry<HeatTransferProcesserBuilder>> HEAT_PROCESSOR_REGISTRY_KEY = REGISTRATE.makeRegistry("htp", RegistryBuilder::new);

    public static void bootSetup() {
        CHHeatTransferProcessers.registerHeatTransferProcesser(HeatRecipeTransferProcesser.TYPE.getPath(), () -> HeatRecipeTransferProcesser::new);
    }

    public static void registerHeatTransferProcesser(String name, Supplier<HeatTransferProcesserBuilder> heatTransferProcesserBuilder) {
        REGISTRATE.generic(name, HEAT_PROCESSOR_REGISTRY_KEY, NonNullSupplier.of(heatTransferProcesserBuilder)).register();
    }

    public static Optional<HeatTransferProcesser> findProcesser(Level level, BlockPos blockPos, Direction face) {
        return REGISTRATE.getAll(HEAT_PROCESSOR_REGISTRY_KEY).stream().map(d -> ((HeatTransferProcesserBuilder)d.get()).create()).filter(h -> h.needHeat(level, blockPos, face)).findFirst();
    }

    public static HeatTransferProcesser fromNbt(Tag tag) {
        Optional<HeatTransferProcesser> heatTransferProcesserOp;
        CompoundTag nbt = (CompoundTag)tag;
        if (nbt.contains("type", 8) && (heatTransferProcesserOp = REGISTRATE.getAll(HEAT_PROCESSOR_REGISTRY_KEY).stream().filter(rE -> rE.getId().equals((Object)ResourceLocation.parse((String)nbt.getString("type")))).map(d -> ((HeatTransferProcesserBuilder)d.get()).create()).findFirst()).isPresent()) {
            HeatTransferProcesser heatTransferProcesser = heatTransferProcesserOp.get();
            heatTransferProcesser.fromNbt(nbt);
            return heatTransferProcesser;
        }
        return null;
    }

    public static CompoundTag toNbt(HeatTransferProcesser heatTransferProcesser) {
        if (heatTransferProcesser.shouldWriteAndReadFromNbt()) {
            CompoundTag nbt = heatTransferProcesser.toNbt();
            nbt.putString("type", heatTransferProcesser.getTypeId().toString());
            return nbt;
        }
        return null;
    }

    @FunctionalInterface
    public static interface HeatTransferProcesserBuilder {
        public HeatTransferProcesser create();
    }
}

