/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.registries;

import com.ffsupver.createheat.CreateHeat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.gui.AllIcons;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class CHIcons
extends AllIcons {
    public static final ResourceLocation ICON_ATLAS_C = CreateHeat.asResource("textures/gui/icons.png");
    public static final int ICON_ATLAS_SIZE_C = 32;
    private static int xC = 0;
    private static int yC = -1;
    public static final CHIcons I_HEAT_LEVEL_NONE = CHIcons.newRow();
    public static final CHIcons I_HEAT_LEVEL_KINDLED = CHIcons.next();
    public static final CHIcons I_HEAT_LEVEL_SEETHING = CHIcons.newRow();
    private int iconXC;
    private int iconYC;

    private static CHIcons next() {
        return new CHIcons(++xC, yC);
    }

    private static CHIcons newRow() {
        xC = 0;
        return new CHIcons(0, ++yC);
    }

    public CHIcons(int xC, int yC) {
        super(xC, yC);
        this.iconXC = xC * 16;
        this.iconYC = yC * 16;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        graphics.blit(ICON_ATLAS_C, x, y, 0, (float)this.iconXC, (float)this.iconYC, 16, 16, 32, 32);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int color) {
        VertexConsumer builder = buffer.getBuffer(RenderType.text((ResourceLocation)ICON_ATLAS_C));
        Matrix4f matrix = ms.last().pose();
        Color rgb = new Color(color);
        int light = 0xF000F0;
        Vec3 vec1 = new Vec3(0.0, 0.0, 0.0);
        Vec3 vec2 = new Vec3(0.0, 1.0, 0.0);
        Vec3 vec3 = new Vec3(1.0, 1.0, 0.0);
        Vec3 vec4 = new Vec3(1.0, 0.0, 0.0);
        float u1 = (float)this.iconXC * 1.0f / 32.0f;
        float u2 = (float)(this.iconXC + 16) * 1.0f / 32.0f;
        float v1 = (float)this.iconYC * 1.0f / 32.0f;
        float v2 = (float)(this.iconYC + 16) * 1.0f / 32.0f;
        this.vertex(builder, matrix, vec1, rgb, u1, v1, light);
        this.vertex(builder, matrix, vec2, rgb, u1, v2, light);
        this.vertex(builder, matrix, vec3, rgb, u2, v2, light);
        this.vertex(builder, matrix, vec4, rgb, u2, v1, light);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void vertex(VertexConsumer builder, Matrix4f matrix, Vec3 vec, Color rgb, float u, float v, int light) {
        builder.addVertex(matrix, (float)vec.x, (float)vec.y, (float)vec.z).setColor(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 255).setUv(u, v).setLight(light);
    }
}

