/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.api;

import com.ffsupver.createheat.CHTags;
import com.ffsupver.createheat.Config;
import com.ffsupver.createheat.api.BlockStateTester;
import com.ffsupver.createheat.registries.CHDatapacks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.api.registry.SimpleRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public record CustomHeater(BlockStateTester heaterState, int heatPerTick, int superHeatCount) {
    public static Codec<CustomHeater> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockStateTester.CODEC.fieldOf("block").forGetter(CustomHeater::heaterState), (App)Codec.INT.fieldOf("heat_per_tick").forGetter(CustomHeater::heatPerTick), (App)Codec.INT.fieldOf("super_heat_count").forGetter(CustomHeater::superHeatCount)).apply((Applicative)i, CustomHeater::new));

    public static Optional<Holder.Reference<CustomHeater>> getFromBlockState(RegistryAccess registryAccess, BlockState state) {
        List<Holder.Reference<CustomHeater>> allList = CustomHeater.getAll(registryAccess);
        return allList.stream().filter(customHeaterReference -> ((CustomHeater)customHeaterReference.value()).heaterState.test(state)).findFirst();
    }

    public static List<Holder.Reference<CustomHeater>> getAll(RegistryAccess registryAccess) {
        return registryAccess.lookupOrThrow(CHDatapacks.CUSTOM_HEATER).listElements().toList();
    }

    public static void registerBoilerHeater(RegistryAccess registryAccess) {
        BoilerHeater.REGISTRY.registerProvider(SimpleRegistry.Provider.forBlockTag(CHTags.BlockTag.CUSTOM_BOILER_HEATER, (Object)new CustomBoilerHeater(registryAccess)));
    }

    public static class CustomBoilerHeater
    implements BoilerHeater {
        private final RegistryAccess registryAccess;

        public CustomBoilerHeater(RegistryAccess registryAccess) {
            this.registryAccess = registryAccess;
        }

        public float getHeat(Level level, BlockPos pos, BlockState state) {
            Optional<Holder.Reference<CustomHeater>> heaterOp = CustomHeater.getFromBlockState(this.registryAccess, state);
            if (heaterOp.isPresent()) {
                float result = (float)((CustomHeater)heaterOp.get().value()).heatPerTick * 1.0f / (float)((Integer)Config.HEAT_PER_FADING_BLAZE.get()).intValue();
                result = result > 0.0f ? (result < 1.0f ? 0.0f : result) : result;
                return result;
            }
            return -1.0f;
        }
    }
}

