/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.block.thermalBlock;

import com.ffsupver.createheat.block.thermalBlock.HeatStorage;
import com.ffsupver.createheat.block.thermalBlock.ThermalBlockEntity;
import com.ffsupver.createheat.registries.CHBlocks;
import com.ffsupver.createheat.util.BlockUtil;
import com.ffsupver.createheat.util.NbtUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StoneHeatStorage
extends HeatStorage {
    private static final Supplier<Integer> HEAT_PER_LAVA = () -> ThermalBlockEntity.MAX_HEAT.get() * 10;
    public final HashSet<BlockPos> stonePosSet;
    private final BlockPos recordControllerPos;
    public boolean shouldChangeController = false;
    private BlockPos newController = null;
    private BlockCounts lastBlockCounts = new BlockCounts();

    public StoneHeatStorage(HashSet<BlockPos> stonePosSet, BlockPos recordController) {
        super(StoneHeatStorage.calculateCapacity(stonePosSet));
        this.stonePosSet = stonePosSet;
        this.recordControllerPos = recordController;
    }

    public StoneHeatStorage(StoneHeatStorage oldSHS, BlockPos newController) {
        this(oldSHS.stonePosSet, newController);
        this.setCapacity(oldSHS.getCapacity());
        this.setAmount(oldSHS.getAmount());
    }

    public void disconnect(BlockPos controllerPos) {
        if (controllerPos.equals((Object)this.recordControllerPos)) {
            this.shouldChangeController = true;
        }
    }

    private void tryChangeToNewController(BlockPos pos, Level level) {
        ThermalBlockEntity thermalBlockEntity;
        BlockEntity blockEntity;
        if (this.shouldChangeController && this.newController == null && (blockEntity = level.getBlockEntity(pos)) instanceof ThermalBlockEntity && (thermalBlockEntity = (ThermalBlockEntity)blockEntity).getControllerEntity().acceptNewStoneHeatStorage(this)) {
            this.newController = thermalBlockEntity.getControllerPos();
        }
    }

    public Set<BlockPos> checkSize(Level level, BlockPos startPos, boolean shouldSetAmountWithoutCheck) {
        int amountFromBlock;
        Set<BlockPos> oldSet = Set.copyOf(this.stonePosSet);
        this.stonePosSet.clear();
        AtomicInteger lavaCount = new AtomicInteger();
        AtomicInteger stoneCount = new AtomicInteger();
        HashSet<BlockPos> controllerPos = new HashSet<BlockPos>();
        BlockUtil.walkAllBlocks(startPos, this.stonePosSet, b -> {
            BlockState bsT = level.getBlockState(b);
            if (StoneHeatStorage.isAvailableLavaBlock(bsT)) {
                lavaCount.getAndIncrement();
            } else if (StoneHeatStorage.isAvailableTStoneBlock(bsT)) {
                stoneCount.getAndIncrement();
            }
            BlockEntity patt0$temp = level.getBlockEntity(b);
            if (patt0$temp instanceof ThermalBlockEntity) {
                ThermalBlockEntity connectTBE = (ThermalBlockEntity)patt0$temp;
                controllerPos.add(connectTBE.getControllerPos());
            }
            return StoneHeatStorage.isAvailableBlock(bsT);
        });
        if (oldSet.size() != this.stonePosSet.size()) {
            this.setCapacity(StoneHeatStorage.calculateCapacity(this.stonePosSet));
        }
        int lC = lavaCount.get();
        int sC = stoneCount.get();
        int n = amountFromBlock = sC + lC > 0 ? lC * this.getCapacity() / (sC + lC) : 0;
        if (shouldSetAmountWithoutCheck) {
            this.setAmount(amountFromBlock);
        } else if (!this.lastBlockCounts.unInit() && this.lastBlockCounts.lava < lC) {
            this.setAmount(Math.max(this.getAmount(), amountFromBlock));
        }
        this.lastBlockCounts = new BlockCounts(sC, lC);
        return controllerPos;
    }

    public boolean checkSize(Level level, BlockPos controllerPos) {
        if (!controllerPos.equals((Object)this.recordControllerPos)) {
            this.tryChangeToNewController(controllerPos, level);
            return true;
        }
        if (!this.stonePosSet.isEmpty()) {
            int oldSize = this.stonePosSet.size();
            this.checkSize(level, this.stonePosSet.iterator().next(), false);
            return this.stonePosSet.size() != oldSize;
        }
        return false;
    }

    public boolean updateBlockState(Level level, BlockPos controllerPos) {
        boolean removeTStone;
        boolean addTStone;
        block7: {
            int aUp;
            int bCount;
            HashSet<BlockPos> stoneBlockPosSet;
            block6: {
                if (!controllerPos.equals((Object)this.recordControllerPos)) {
                    this.tryChangeToNewController(controllerPos, level);
                    return false;
                }
                int lavaCount = 0;
                int stoneCount = 0;
                stoneBlockPosSet = new HashSet<BlockPos>();
                HashSet<BlockPos> lavaBlockPosSet = new HashSet<BlockPos>();
                for (BlockPos sPos : this.stonePosSet) {
                    if (StoneHeatStorage.isAvailableLavaBlock(level.getBlockState(sPos))) {
                        ++lavaCount;
                        lavaBlockPosSet.add(sPos);
                        continue;
                    }
                    if (!level.getBlockState(sPos).is(CHBlocks.TIGHT_COMPRESSED_STONE)) continue;
                    ++stoneCount;
                    stoneBlockPosSet.add(sPos);
                }
                if (lavaCount + stoneCount == 0) {
                    return false;
                }
                bCount = stoneCount + lavaCount;
                aUp = this.getCapacity() * (lavaCount + 1) / bCount;
                int aDw = this.getCapacity() * lavaCount / bCount;
                addTStone = aDw > this.getAmount();
                boolean bl = removeTStone = aUp <= this.getAmount();
                if (!addTStone) break block6;
                int countToAdd = (aDw - this.getAmount()) * bCount / this.getCapacity() + 1;
                ArrayList lavaPosList = new ArrayList(lavaBlockPosSet);
                for (int i = 0; i < Math.min(countToAdd, lavaPosList.size()); ++i) {
                    level.setBlock((BlockPos)lavaPosList.get(i), CHBlocks.TIGHT_COMPRESSED_STONE.getDefaultState(), 3);
                }
                break block7;
            }
            if (!removeTStone) break block7;
            int countToRemove = (this.getAmount() - aUp) * bCount / this.getCapacity() + 1;
            ArrayList stonePosList = new ArrayList(stoneBlockPosSet);
            for (int i = 0; i < Math.min(countToRemove, stonePosList.size()); ++i) {
                level.setBlock((BlockPos)stonePosList.get(i), Blocks.LAVA.defaultBlockState(), 3);
            }
        }
        return addTStone || removeTStone;
    }

    public static boolean isAvailableBlock(BlockState bsT) {
        return StoneHeatStorage.isAvailableLavaBlock(bsT) || StoneHeatStorage.isAvailableTStoneBlock(bsT);
    }

    public static boolean isAvailableLavaBlock(BlockState bsT) {
        return bsT.is(Blocks.LAVA) && (Integer)bsT.getValue((Property)LiquidBlock.LEVEL) == 0;
    }

    public static boolean isAvailableTStoneBlock(BlockState bsT) {
        return bsT.is((Block)CHBlocks.TIGHT_COMPRESSED_STONE.get());
    }

    private static int calculateCapacity(Set<BlockPos> stonePosSet) {
        return stonePosSet.size() * HEAT_PER_LAVA.get();
    }

    public void calculateAmountByBlock(Level level) {
        for (BlockPos stonePos : this.stonePosSet) {
            BlockState blockState = level.getBlockState(stonePos);
            this.setAmount(this.getAmount() + (StoneHeatStorage.isAvailableLavaBlock(blockState) ? HEAT_PER_LAVA.get() : 0));
        }
    }

    public boolean hasPos(BlockPos pos) {
        return this.stonePosSet.contains(pos);
    }

    @Override
    public void fromNbt(CompoundTag nbt) {
        super.fromNbt(nbt);
        this.stonePosSet.clear();
        this.stonePosSet.addAll(NbtUtil.readBlockPosFromNbtList(nbt.getList("stone_pos", 10)));
        this.shouldChangeController = nbt.getBoolean("should_change_c");
    }

    public static StoneHeatStorage cFromNbt(CompoundTag tag) {
        StoneHeatStorage r = new StoneHeatStorage(new HashSet<BlockPos>(), NBTHelper.readBlockPos((CompoundTag)tag, (String)"record_controller"));
        r.fromNbt(tag);
        return r;
    }

    public boolean shouldWriteToNbt(BlockPos pos) {
        return pos.equals((Object)this.recordControllerPos);
    }

    @Override
    public CompoundTag toNbt() {
        CompoundTag nbt = super.toNbt();
        nbt.put("stone_pos", (Tag)NbtUtil.writeBlockPosToNbtList(this.stonePosSet));
        nbt.put("record_controller", NbtUtils.writeBlockPos((BlockPos)this.recordControllerPos));
        nbt.putBoolean("should_change_c", this.shouldChangeController);
        return nbt;
    }

    public boolean isConnect(Set<BlockPos> posSet) {
        for (BlockPos thisPos : this.stonePosSet) {
            for (Direction d : Direction.values()) {
                for (BlockPos thPos : posSet) {
                    if (!thisPos.relative(d).equals((Object)thPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static class BlockCounts {
        private Integer stone;
        private Integer lava;

        public BlockCounts(int stone, int lava) {
            this.stone = stone;
            this.lava = lava;
        }

        public BlockCounts() {
        }

        public boolean unInit() {
            return this.stone == null || this.lava == null;
        }
    }
}

