/*
 * Decompiled with CFR 0.152.
 */
package com.ffsupver.createheat.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public final class NbtUtil {
    public static ListTag writeBlockPosToNbtList(Collection<BlockPos> blockPosCollection) {
        return NbtUtil.writeToNbtList(blockPosCollection, NbtUtil::blockPosToNbt);
    }

    public static Collection<BlockPos> readBlockPosFromNbtList(ListTag listTag) {
        return NbtUtil.readListFromNbt(listTag, NbtUtil::blockPosFromNbt);
    }

    public static <K, V> ListTag writeMapToNbtList(Map<K, V> map, Function<K, Tag> writeKey, Function<V, Tag> writeValue) {
        return NbtUtil.writeToNbtList(map.entrySet(), kvEntry -> {
            CompoundTag tag = new CompoundTag();
            Tag keyTag = (Tag)writeKey.apply(kvEntry.getKey());
            Tag valurTag = (Tag)writeValue.apply(kvEntry.getValue());
            if (keyTag != null && valurTag != null) {
                tag.put("k", keyTag);
                tag.put("v", valurTag);
                return tag;
            }
            return null;
        });
    }

    public static <K, V> Map<K, V> readMapFromNbtList(ListTag listTag, Function<Tag, K> readKey, Function<Tag, V> readValue) {
        HashMap result = new HashMap();
        NbtUtil.readListFromNbt(listTag, tag -> {
            result.put(readKey.apply(((CompoundTag)tag).get("k")), readValue.apply(((CompoundTag)tag).get("v")));
            return null;
        });
        return result;
    }

    public static <T> ListTag writeToNbtList(Collection<T> collection, Function<T, Tag> write) {
        ListTag listTag = new ListTag();
        for (T item : collection) {
            Tag itemTag = write.apply(item);
            if (itemTag == null) continue;
            listTag.add((Object)itemTag);
        }
        return listTag;
    }

    public static <T> Collection<T> readListFromNbt(ListTag listTag, Function<Tag, T> read) {
        ArrayList<T> collection = new ArrayList<T>();
        for (Tag tag : listTag) {
            T item = read.apply(tag);
            if (item == null) continue;
            collection.add(item);
        }
        return collection;
    }

    public static BlockPos blockPosFromNbt(Tag tag) {
        return NBTHelper.readBlockPos((CompoundTag)((CompoundTag)tag), (String)"p");
    }

    public static CompoundTag blockPosToNbt(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.put("p", NbtUtils.writeBlockPos((BlockPos)pos));
        return tag;
    }
}

