/*
 * Decompiled with CFR 0.152.
 */
package nnhomoli.mutator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1320;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import nnhomoli.api.abstractedutilities.GenericObjectIterator;
import nnhomoli.api.abstractedutilities.config.FabricConfigMapper;
import nnhomoli.mutator.MutatorDataGenerator;
import nnhomoli.mutator.settings.IgnoreSettings;
import nnhomoli.mutator.settings.ScalingSettings;
import nnhomoli.mutator.world.MutatorGamerules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Mutator
implements ModInitializer {
    private static final String modId = "mutator";
    private static final Logger log = LoggerFactory.getLogger((String)"mutator");
    private static IgnoreSettings ignoreSettings = new IgnoreSettings();
    private static ScalingSettings scalingSettings = new ScalingSettings();
    private static final GenericObjectIterator<class_6880<class_1320>> attributeIterator = new GenericObjectIterator();

    public void onInitialize() {
        attributeIterator.readStaticFields(class_5134.class, class_6880.class);
        Mutator.loadConfig();
        MutatorGamerules.init();
        if (scalingSettings.shouldScaleLoot()) {
            log.info("Modifying loot...");
            MutatorDataGenerator.modifyLootTables();
        }
        log.info("Mutator loaded!");
    }

    public static void loadConfig() {
        FabricConfigMapper mapper = new FabricConfigMapper(new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT), modId);
        ignoreSettings = (IgnoreSettings)mapper.readOrWriteFor("ignore.json", (Object)ignoreSettings, IgnoreSettings.class);
        scalingSettings = (ScalingSettings)mapper.readOrWriteFor("scaling.json", (Object)scalingSettings, ScalingSettings.class);
    }

    public static Logger getLogger() {
        return log;
    }

    public static IgnoreSettings getIgnoreSettings() {
        return ignoreSettings;
    }

    public static ScalingSettings getScalingSettings() {
        return scalingSettings;
    }

    public static GenericObjectIterator<class_6880<class_1320>> getAttributeIterator() {
        return attributeIterator;
    }

    public static class_2960 getId(String path) {
        return class_2960.method_60655((String)modId, (String)path);
    }

    public static String getModId() {
        return modId;
    }
}

