/*
 * Decompiled with CFR 0.152.
 */
package nnhomoli.mutator.lib;

import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1928;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import nnhomoli.api.abstractedutilities.impl.ExtendedServerWorld;
import nnhomoli.mutator.Mutator;
import nnhomoli.mutator.lib.MutatorAdditionalScaling;
import nnhomoli.mutator.world.MutatorGamerules;

public final class Scaling {
    private final double negativeMultiplier;
    private final double positiveMultiplier;
    private final double weirdness;
    private final class_3218 world;

    public Scaling(class_5425 w) {
        this(w.method_8410());
    }

    public Scaling(class_3218 w) {
        this.world = w;
        class_1928 rules = this.world.method_64395();
        this.negativeMultiplier = ((DoubleRule)rules.method_20746(MutatorGamerules.MUTATION_NEGATIVE_ATTRIBUTE_MULTIPLIER)).get();
        this.positiveMultiplier = ((DoubleRule)rules.method_20746(MutatorGamerules.MUTATION_POSITIVE_ATTRIBUTE_MULTIPLIER)).get();
        this.weirdness = ((DoubleRule)rules.method_20746(MutatorGamerules.MUTATION_WEIRDNESS)).get();
    }

    public void randomizeAttributes(class_1309 entity) {
        double scale = this.getNewPartitionedScale(entity.method_18377(entity.method_18376()), entity.method_73189(), entity.method_55693());
        entity.method_5996(class_5134.field_47760).method_6192(scale);
        Mutator.getAttributeIterator().forEachWith(entry -> entry != class_5134.field_47760 && entity.method_6127().method_45331(entry) && !Mutator.getIgnoreSettings().isIgnoredAttribute((class_6880<class_1320>)entry), entry -> {
            class_1324 ati = entity.method_5996(entry);
            ati.method_6192(this.scaleAttribute(ati.method_6201(), entry.method_55840(), scale));
        });
        ((MutatorAdditionalScaling)entity).mutator$doAdditionalScaling(this.world.method_64395(), scale);
        entity.method_6033(entity.method_6063());
    }

    public double scaleAttribute(double value, String id, double scale) {
        value = Math.max(value, 0.1);
        if (Mutator.getScalingSettings().isScalingAttribute(id)) {
            boolean isNegative = Mutator.getScalingSettings().isNegativeAttribute(id);
            double scaling = scale * (isNegative ? this.negativeMultiplier : this.positiveMultiplier);
            value = isNegative ? value / scaling : value * scaling;
        } else {
            value = ThreadLocalRandom.current().nextDouble(value / this.weirdness, value * this.weirdness);
        }
        return value;
    }

    public double getNewPartitionedScale(class_4048 dimensions, class_243 pos, double normal) {
        return Scaling.getPartitionedScale(this.world, dimensions, pos, normal, ThreadLocalRandom.current().nextDouble(normal, normal * this.weirdness));
    }

    public static double getPartitionedScale(class_3218 world, class_4048 dimensions, class_243 pos, double normal, double scale) {
        double cleanPartition = normal;
        for (int i = world.method_64395().method_8356(MutatorGamerules.MUTATION_SIZE_PARTITIONING); i > 0; --i) {
            double partition = scale / (double)i;
            if (partition < normal) continue;
            if (((ExtendedServerWorld)world).abstractedutilities$tryGetBlockCollisions(null, dimensions.method_18383((float)partition).method_30757(pos), 3).iterator().hasNext()) break;
            cleanPartition = partition;
        }
        return cleanPartition;
    }

    public static int getTameRandom(class_3218 world, class_5819 instance, int original, double scale) {
        return world.method_64395().method_8355(MutatorGamerules.DO_MOB_TAME_SCALING) ? instance.method_43048((int)((double)original * scale)) : instance.method_43048(original);
    }

    public static boolean shouldMutate(class_3218 w) {
        return ThreadLocalRandom.current().nextInt(100) <= w.method_64395().method_8356(MutatorGamerules.MUTATION_CHANGE);
    }

    public static boolean shouldMutate(class_5425 w) {
        return w.method_8410().method_64395().method_8355(MutatorGamerules.DO_MOB_MUTATION) && ThreadLocalRandom.current().nextInt(100) <= w.method_8410().method_64395().method_8356(MutatorGamerules.MUTATION_CHANGE);
    }
}

