package nnhomoli.mutator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1320;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import nnhomoli.api.abstractedutilities.config.FabricConfigMapper;
import nnhomoli.api.abstractedutilities.GenericObjectIterator;

import nnhomoli.mutator.settings.ScalingSettings;
import nnhomoli.mutator.settings.IgnoreSettings;
import nnhomoli.mutator.world.MutatorGamerules;

public final class Mutator implements ModInitializer {
    private static final String modId = "mutator";
    private static final Logger log = LoggerFactory.getLogger(modId);

    private static IgnoreSettings ignoreSettings = new IgnoreSettings();
    private static ScalingSettings scalingSettings = new ScalingSettings();

    private static final GenericObjectIterator<class_6880<class_1320>> attributeIterator = new GenericObjectIterator<>();

    @Override
    public void onInitialize() {
        attributeIterator.readStaticFields(class_5134.class,class_6880.class);

        loadConfig();
        MutatorGamerules.init();

        if(scalingSettings.shouldScaleLoot()) {
            log.info("Modifying loot...");
            MutatorDataGenerator.modifyLootTables();
        }

        log.info("Mutator loaded!");
    }

    public static void loadConfig() {
        FabricConfigMapper mapper = new FabricConfigMapper(new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT),modId);
        ignoreSettings = mapper.readOrWriteFor("ignore.json",ignoreSettings,IgnoreSettings.class);
        scalingSettings = mapper.readOrWriteFor("scaling.json",scalingSettings,ScalingSettings.class);
    }

    public static Logger getLogger() {
        return log;
    }
    public static IgnoreSettings getIgnoreSettings() {
        return ignoreSettings;
    }
    public static ScalingSettings getScalingSettings() {
        return scalingSettings;
    }
    public static GenericObjectIterator<class_6880<class_1320>> getAttributeIterator() {
        return attributeIterator;
    }
    public static class_2960 getId(String path) {
        return class_2960.method_60655(modId,path);
    }
    public static String getModId() {
        return modId;
    }
}
