package nnhomoli.mutator.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import nnhomoli.mutator.lib.Scaling;
import static nnhomoli.mutator.Mutator.getAttributeIterator;
import static nnhomoli.mutator.world.MutatorGamerules.DO_ANIMAL_ATTRIBUTE_INHERITANCE;

@Mixin(class_1429.class)
abstract class AnimalEntityMixin extends class_1296 {
    protected AnimalEntityMixin(class_1299<? extends class_1296> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "breed(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/passive/AnimalEntity;Lnet/minecraft/entity/passive/PassiveEntity;)V",
            at= @At(value = "INVOKE", target = "Lnet/minecraft/server/world/ServerWorld;sendEntityStatus(Lnet/minecraft/entity/Entity;B)V"))
    private void breed(class_3218 world, class_1429 other, class_1296 baby, CallbackInfo ci) {
        if(method_73183() instanceof class_3218 w && w.method_64395().method_8355(DO_ANIMAL_ATTRIBUTE_INHERITANCE)) {

            ThreadLocalRandom random = ThreadLocalRandom.current();
            if(random.nextBoolean()) {
                getAttributeIterator().forEachWith(e ->
                        method_6127().method_45331(e) &&
                        other.method_6127().method_45331(e) &&
                        baby.method_6127().method_45331(e) &&
                            method_45326(e) > 0 && other.method_45326(e) > 0,
                        entry -> {

                    baby.method_5996(entry)
                            .method_6192(
                                    random.nextDouble(
                                            Math.min(method_45326(entry),
                                                    other.method_45326(entry)
                                            )
                                    )
                            );
                });
            } else if(Scaling.shouldMutate(w)) new Scaling(w).randomizeAttributes(baby);
        }
    }
}
