package nnhomoli.mutator.mixin;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1299;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3169;
import org.spongepowered.asm.mixin.Mixin;

import static nnhomoli.mutator.Mutator.getLogger;
import static nnhomoli.mutator.world.MutatorGamerules.DO_MOB_EXPLOSION_SCALING;

@Mixin(class_1548.class)
abstract class CreeperEntityMixin extends MobEntityMixin {
    protected CreeperEntityMixin(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public void mutator$doAdditionalScaling(class_1928 rules,double scale) {
        super.mutator$doAdditionalScaling(rules,scale);
        if(rules.method_8355(DO_MOB_EXPLOSION_SCALING)) {
            class_3169 data = new class_3169(this);
            class_2487 compound = data.method_13881();
            compound.method_10569("ExplosionRadius",(int)(3*scale));

            try {
                data.method_13880(compound);
            } catch (CommandSyntaxException e) {
                getLogger().error("Failed to set ExplosionRadius! {}",e.getContext());
            }
        }
    }
}
