package nnhomoli.mutator.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static nnhomoli.mutator.Mutator.getIgnoreSettings;
import static nnhomoli.mutator.Mutator.getAttributeIterator;
import static nnhomoli.mutator.world.MutatorGamerules.DO_MOB_ATTRIBUTE_PRESERVATION;

import net.minecraft.class_10179;
import net.minecraft.class_10181;
import net.minecraft.class_1308;
import net.minecraft.class_1324;
import net.minecraft.class_3218;

@Mixin(class_10181.class)
abstract class EntityConversionTypeMixin {
    @Inject(method = "copyData",at=@At("TAIL"))
    private void copyData(class_1308 oldEntity, class_1308 newEntity, class_10179 context, CallbackInfo ci) {
        if(getIgnoreSettings().shouldIgnoreConversion(newEntity.method_5864())) return;

        if(newEntity.method_73183() instanceof class_3218 w) {
            if (!w.method_64395().method_8355(DO_MOB_ATTRIBUTE_PRESERVATION)) return;

            getAttributeIterator().forEachWith(
                    entry -> oldEntity.method_6127().method_45331(entry) && newEntity.method_6127().method_45331(entry),
                    entry -> {
                class_1324 attribute = oldEntity.method_5996(entry);
                class_1324 newAttribute = newEntity.method_5996(entry);

                newAttribute.method_26831(attribute);
            });

            newEntity.method_6033(newEntity.method_6063());
        }
    }
}
