package nnhomoli.mutator.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import nnhomoli.mutator.lib.Scaling;
import nnhomoli.mutator.lib.MutatorAdditionalScaling;
import static nnhomoli.mutator.Mutator.getIgnoreSettings;
import static nnhomoli.mutator.world.MutatorGamerules.*;

@Mixin(class_1308.class)
abstract class MobEntityMixin extends class_1309 implements MutatorAdditionalScaling {
    @Shadow protected int experiencePoints;

    protected MobEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public void mutator$doAdditionalScaling(class_1928 rules, double scale) {
        if(rules.method_8355(DO_MOB_EXP_SCALING)) experiencePoints = (int)(experiencePoints * scale);
    }

    @Inject(method = "initialize",at=@At("RETURN"))
    private void initialize(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, CallbackInfoReturnable<class_1315> cir) {
        if (getIgnoreSettings().isIgnoredReason(spawnReason) || getIgnoreSettings().isIgnoredType(method_5864())) return;
        if(Scaling.shouldMutate(world)) new Scaling(world).randomizeAttributes(this);
    }

    @Redirect(method = "getAttackBox",at= @At(value = "INVOKE", target = "Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private class_238 getAttackBox(class_238 instance, double x, double y, double z) {
        float scale = method_55693();
        if(scale > 10F && method_73183() instanceof class_3218 w && w.method_64395().method_8355(DO_MOB_RANGE_SCALING)) {
            float multiplier = scale * 0.1F;
            instance = instance.method_1009(x*multiplier,y,z*multiplier);
        }

        return instance;
    }

    @ModifyReturnValue(method = "getItemPickUpRangeExpander",at=@At("RETURN"))
    private class_2382 getItemPickUpRangeExpander(class_2382 original) {
        float scale = method_55693();
        if(scale > 10F && method_73183() instanceof class_3218 w && w.method_64395().method_8355(DO_MOB_RANGE_SCALING))
            original = original.method_35862((int)(scale*0.1F));

        return original;
    }
}
