package nnhomoli.mutator.settings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_3730;
import net.minecraft.class_6880;

@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public final class IgnoreSettings {
    private final List<String> types;
    private final List<String> reasons;
    private final List<String> attributes;
    private final List<String> conversion;

    public IgnoreSettings() {
        reasons = List.of(
                "SPAWNER",
                "TRIAL_SPAWNER",
                "BREEDING",
                "STRUCTURE",
                "REINFORCEMENT",
                "PATROL",
                "DIMENSION_TRAVEL",
                "LOAD",
                "MOB_SUMMONED",
                "CHUNK_GENERATION",
                "CONVERSION"
        );
        attributes = List.of(
                "minecraft:waypoint_receive_range",
                "minecraft:waypoint_transmit_range",
                "minecraft:gravity",
                "minecraft:movement_speed",
                "minecraft:water_movement_efficiency",
                "minecraft:flying_speed",
                "minecraft:sneaking_speed",
                "minecraft:camera_distance",
                "minecraft:follow_range"
        );

        types = List.of(
                "minecraft:villager",
                "minecraft:pillager",
                "minecraft:illusioner",
                "minecraft:vindicator",
                "minecraft:witch",
                "minecraft:evoker",
                "minecraft:piglin",
                "minecraft:piglin_brute",
                "minecraft:ender_dragon",
                "minecraft:wandering_trader",
                "minecraft:warden"
        );

        conversion = List.of(
                "minecraft:villager",
                "minecraft:zombie_villager"
        );
    }

    public boolean shouldIgnoreConversion(class_1299<?> type) {
        return shouldIgnoreConversion(type.method_40124().method_55840());
    }
    public boolean shouldIgnoreConversion(String type) {
        return conversion.contains(type);
    }
    public boolean isIgnoredType(class_1299<?> type) {
        return isIgnoredType(type.method_40124().method_55840());
    }
    public boolean isIgnoredType(String type) {
        return types.contains(type);
    }
    public boolean isIgnoredReason(class_3730 reason) {
        return isIgnoredReason(reason.name());
    }
    public boolean isIgnoredReason(String  reason) {
        return reasons.contains(reason);
    }
    public boolean isIgnoredAttribute(class_6880<class_1320> entry) {
        return isIgnoredAttribute(entry.method_55840());
    }
    public boolean isIgnoredAttribute(String key) {
        return attributes.contains(key);
    }
}
