package nnhomoli.mutator.settings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import java.util.List;

@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public final class ScalingSettings {
    private final List<String> positive;
    private final List<String> negative;

    private final boolean lootScaling;

    public ScalingSettings() {
        positive = List.of(
                "minecraft:jump_strength",
                "minecraft:attack_damage",
                "minecraft:attack_knockback",
                "minecraft:knockback_resistance",
                "minecraft:max_health",
                "minecraft:step_height",
                "minecraft:oxygen_bonus"
        );

        negative = List.of(
                "minecraft:attack_speed"
        );


        lootScaling = true;
    }

    public boolean isPositiveAttribute(String key) {
        return positive.contains(key);
    }
    public boolean isNegativeAttribute(String key) {
        return negative.contains(key);
    }
    public boolean isScalingAttribute(String key) {
        return isPositiveAttribute(key) || isNegativeAttribute(key);
    }
    public boolean shouldScaleLoot() {
        return lootScaling;
    }
}
