/*
 * Decompiled with CFR 0.152.
 */
package nnhomoli.mutator.settings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public final class ScalingSettings {
    private final List<String> positive = List.of("minecraft:jump_strength", "minecraft:attack_damage", "minecraft:attack_knockback", "minecraft:knockback_resistance", "minecraft:max_health", "minecraft:step_height", "minecraft:oxygen_bonus");
    private final List<String> negative = List.of("minecraft:attack_speed");
    private final boolean lootScaling;

    public ScalingSettings() {
        this.lootScaling = true;
    }

    public boolean isPositiveAttribute(String key) {
        return this.positive.contains(key);
    }

    public boolean isNegativeAttribute(String key) {
        return this.negative.contains(key);
    }

    public boolean isScalingAttribute(String key) {
        return this.isPositiveAttribute(key) || this.isNegativeAttribute(key);
    }

    public boolean shouldScaleLoot() {
        return this.lootScaling;
    }
}

