/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.bearminimum;

import com.startraveler.bearminimum.CommonClass;
import com.startraveler.bearminimum.Constants;
import com.startraveler.bearminimum.ModFoods;
import com.startraveler.bearminimum.client.model.BlackBearModel;
import com.startraveler.bearminimum.client.model.BrownBearModel;
import com.startraveler.bearminimum.client.renderer.BlackBearRenderer;
import com.startraveler.bearminimum.client.renderer.BrownBearRenderer;
import com.startraveler.bearminimum.entity.BlackBearEntity;
import com.startraveler.bearminimum.entity.BrownBearEntity;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="bearminimum")
public class BearMinimum {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"bearminimum");
    public static final RegistryObject<EntityType<BlackBearEntity>> BLACK_BEAR = ENTITY_TYPES.register("black_bear", () -> EntityType.Builder.m_20704_(BlackBearEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.4f, 1.4f).m_20702_(10).m_20712_("black_bear"));
    public static final RegistryObject<EntityType<BrownBearEntity>> BROWN_BEAR = ENTITY_TYPES.register("brown_bear", () -> EntityType.Builder.m_20704_(BrownBearEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.8f, 1.8f).m_20702_(10).m_20712_("brown_bear"));
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"bearminimum");
    public static final RegistryObject<Item> BLACK_BEAR_SPAWN_EGG = ITEMS.register("black_bear_spawn_egg", () -> new ForgeSpawnEggItem(() -> (EntityType)BLACK_BEAR.get(), 0x161619, 0, new Item.Properties()));
    public static final RegistryObject<Item> BROWN_BEAR_SPAWN_EGG = ITEMS.register("brown_bear_spawn_egg", () -> new ForgeSpawnEggItem(() -> (EntityType)BROWN_BEAR.get(), 5715237, 3679255, new Item.Properties()));
    public static final RegistryObject<Item> BEAR_MEAT = ITEMS.register("bear_meat", () -> new Item(new Item.Properties().m_41489_(ModFoods.BEAR_MEAT)));
    public static final RegistryObject<Item> COOKED_BEAR_MEAT = ITEMS.register("cooked_bear_meat", () -> new Item(new Item.Properties().m_41489_(ModFoods.COOKED_BEAR_MEAT)));
    private static final ResourceLocation POLAR_BEAR_LOOT_TABLE_ID = new ResourceLocation("minecraft", "entities/polar_bear");
    private static final ResourceLocation MODIFIED_POLAR_BEAR_LOOT_TABLE_ID = Constants.id("entities/polar_bear");

    public BearMinimum() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modBus = context.getModEventBus();
        Constants.LOG.info("Hello Forge world!");
        CommonClass.init();
        ITEMS.register(modBus);
        ENTITY_TYPES.register(modBus);
    }

    @Mod.EventBusSubscriber(modid="bearminimum", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventBusEvents {
        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            ResourceLocation tableName = event.getName();
            if (tableName.equals((Object)POLAR_BEAR_LOOT_TABLE_ID)) {
                LootPool customPool = LootPool.m_79043_().name("bearminimum_add_bear_drops").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)MODIFIED_POLAR_BEAR_LOOT_TABLE_ID)).m_79082_();
                event.getTable().addPool(customPool);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="bearminimum", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventBusEvents {
        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)BLACK_BEAR.get(), BlackBearEntity.m_29560_().m_22265_());
            event.put((EntityType)BROWN_BEAR.get(), BrownBearEntity.m_29560_().m_22265_());
        }

        @SubscribeEvent
        public static void addCreative(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.f_256839_) {
                event.accept(BEAR_MEAT);
                event.accept(COOKED_BEAR_MEAT);
            }
            if (event.getTabKey() == CreativeModeTabs.f_256731_) {
                event.m_246326_((ItemLike)BLACK_BEAR_SPAWN_EGG.get());
                event.m_246326_((ItemLike)BROWN_BEAR_SPAWN_EGG.get());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="bearminimum", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEventBusEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)BLACK_BEAR.get()), BlackBearRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)BROWN_BEAR.get()), BrownBearRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(BlackBearModel.BODY_LAYER, BlackBearModel::createBodyLayer);
            event.registerLayerDefinition(BrownBearModel.BODY_LAYER, BrownBearModel::createBodyLayer);
        }
    }
}

