/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.bearminimum.client.model;

import com.startraveler.bearminimum.Constants;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.animal.PolarBear;

public class BlackBearModel<T extends PolarBear>
extends QuadrupedModel<T> {
    public static final ModelLayerLocation BODY_LAYER = new ModelLayerLocation(Constants.id("black_bear"), "main");

    public BlackBearModel(ModelPart root) {
        super(root, true, 16.0f, 4.0f, 2.25f, 2.0f, 24);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(1, 0).m_171488_(-3.0f, -3.0f, -6.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(1, 44).m_171488_(-1.5f, 0.0f, -9.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(26, 0).m_171488_(2.0f, -4.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(26, 0).m_171488_(-4.0f, -4.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)-11.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(4, 21).m_171488_(-3.5f, -12.0f, -7.0f, 11.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(40, 0).m_171488_(-3.5f, -23.0f, -7.0f, 11.0f, 11.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)10.0f, (float)12.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = partdefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(52, 24).m_171488_(-3.0f, 0.0f, -2.0f, 4.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)16.0f, (float)5.0f));
        PartDefinition leftHindLeg = partdefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(52, 24).m_171488_(-1.0f, 0.0f, -2.0f, 4.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)16.0f, (float)5.0f));
        PartDefinition rightFrontLeg = partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(51, 41).m_171488_(-2.5f, 0.0f, -1.0f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)16.0f, (float)-7.0f));
        PartDefinition leftFrontLeg = partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(51, 41).m_171488_(-1.5f, 0.0f, -1.0f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)16.0f, (float)-7.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float partialTick = ageInTicks - (float)((PolarBear)entity).f_19797_;
        float standingScaleSquared = entity.m_29569_(partialTick);
        standingScaleSquared *= standingScaleSquared;
        float complement = 1.0f - standingScaleSquared;
        this.f_103493_.f_104203_ = 1.5707964f - standingScaleSquared * (float)Math.PI * 0.35f;
        this.f_103493_.f_104201_ = 10.0f * complement + 15.0f * standingScaleSquared;
        this.f_170854_.f_104201_ = 16.0f * complement - 1.0f * standingScaleSquared;
        this.f_170854_.f_104202_ = -7.0f * complement - 3.0f * standingScaleSquared;
        ModelPart part = this.f_170854_;
        part.f_104203_ -= standingScaleSquared * (float)Math.PI * 0.45f;
        this.f_170855_.f_104201_ = this.f_170854_.f_104201_;
        this.f_170855_.f_104202_ = this.f_170854_.f_104202_;
        part = this.f_170855_;
        part.f_104203_ -= standingScaleSquared * (float)Math.PI * 0.45f;
        if (this.f_102610_) {
            this.f_103492_.f_104201_ = 10.0f * complement - 9.0f * standingScaleSquared;
            this.f_103492_.f_104202_ = -16.0f * complement - 12.0f * standingScaleSquared;
        } else {
            this.f_103492_.f_104201_ = 12.0f * complement - 7.0f * standingScaleSquared;
            this.f_103492_.f_104202_ = -11.0f * complement - 1.0f * standingScaleSquared;
        }
        part = this.f_103492_;
        part.f_104203_ += standingScaleSquared * (float)Math.PI * 0.15f;
    }
}

