/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.bearminimum.client.model;

import com.startraveler.bearminimum.Constants;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.animal.PolarBear;

public class BrownBearModel<T extends PolarBear>
extends QuadrupedModel<T> {
    public static final ModelLayerLocation BODY_LAYER = new ModelLayerLocation(Constants.id("brown_bear"), "main");

    public BrownBearModel(ModelPart root) {
        super(root, true, 16.0f, 4.0f, 2.25f, 2.0f, 24);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -5.0f, -7.0f, 9.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(0, 56).m_171488_(-2.5f, -2.0f, -11.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(21, 61).m_171488_(3.5f, -6.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(21, 61).m_171488_(-5.5f, -6.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)-13.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-5.0f, -13.0f, -7.0f, 14.0f, 14.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(37, 0).m_171488_(-4.0f, -25.0f, -7.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)9.0f, (float)12.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = partdefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(50, 30).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)14.0f, (float)6.0f));
        PartDefinition leftHindLeg = partdefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(50, 30).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)14.0f, (float)6.0f));
        PartDefinition rightFrontLeg = partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(50, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)14.0f, (float)-8.0f));
        PartDefinition leftFrontLeg = partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(50, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)14.0f, (float)-8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float partialTick = ageInTicks - (float)((PolarBear)entity).f_19797_;
        float standAnimationScale = entity.m_29569_(partialTick);
        standAnimationScale *= standAnimationScale;
        float complement = 1.0f - standAnimationScale;
        this.f_103493_.f_104203_ = 1.5707964f - standAnimationScale * (float)Math.PI * 0.35f;
        this.f_103493_.f_104201_ = 9.0f * complement + 11.0f * standAnimationScale;
        this.f_170854_.f_104201_ = 14.0f * complement - 6.0f * standAnimationScale;
        this.f_170854_.f_104202_ = -8.0f * complement - 4.0f * standAnimationScale;
        ModelPart modelPart = this.f_170854_;
        modelPart.f_104203_ -= standAnimationScale * (float)Math.PI * 0.45f;
        this.f_170855_.f_104201_ = this.f_170854_.f_104201_;
        this.f_170855_.f_104202_ = this.f_170854_.f_104202_;
        modelPart = this.f_170855_;
        modelPart.f_104203_ -= standAnimationScale * (float)Math.PI * 0.45f;
        if (this.f_102610_) {
            this.f_103492_.f_104201_ = 10.0f * complement - 9.0f * standAnimationScale;
            this.f_103492_.f_104202_ = -14.0f * complement - 8.0f * standAnimationScale;
        } else {
            this.f_103492_.f_104201_ = 10.0f * complement - 12.0f * standAnimationScale;
            this.f_103492_.f_104202_ = -14.0f * complement - 1.0f * standAnimationScale;
        }
        modelPart = this.f_103492_;
        modelPart.f_104203_ += standAnimationScale * (float)Math.PI * 0.15f;
    }
}

