/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.bearminimum.entity.goal;

import com.startraveler.bearminimum.entity.AbstractBearEntity;
import com.startraveler.bearminimum.mixin.CropBlockMixin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ForageGoal
extends MoveToBlockGoal {
    public static final int TICKS_TILL_START_AGAIN = 10;
    private final AbstractBearEntity bear;
    private boolean wantsToRaid;
    private boolean canRaid;

    public ForageGoal(AbstractBearEntity bear) {
        super((PathfinderMob)bear, (double)0.7f, 16);
        this.bear = bear;
    }

    public boolean canUse() {
        if (this.nextStartTick <= 0) {
            if (!this.bear.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return false;
            }
            this.canRaid = false;
            this.wantsToRaid = this.bear.wantsMoreFood();
        }
        return super.canUse();
    }

    public boolean canContinueToUse() {
        return this.canRaid && super.canContinueToUse();
    }

    public void tick() {
        super.tick();
        this.bear.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, (double)(this.blockPos.getY() + 1), (double)this.blockPos.getZ() + 0.5, 10.0f, (float)this.bear.getMaxHeadXRot());
        if (this.isReachedTarget()) {
            Level level = this.bear.level();
            BlockPos blockpos = this.blockPos.above();
            BlockState blockstate = level.getBlockState(blockpos);
            Block block = blockstate.getBlock();
            if (this.canRaid && blockstate.is(this.bear.getFoodPreferences().forageTag())) {
                if (block instanceof CropBlock) {
                    int minAge;
                    CropBlock cropBlock = (CropBlock)block;
                    IntegerProperty property = ((CropBlockMixin)cropBlock).invokeGetAgeProperty();
                    int age = (Integer)blockstate.getValue((Property)property);
                    if (age == (minAge = property.getPossibleValues().stream().mapToInt(a -> a).min().orElse(0))) {
                        level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 2);
                        level.destroyBlock(blockpos, true, (Entity)this.bear);
                    } else {
                        level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)property, (Comparable)Integer.valueOf(minAge)), 2);
                        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)this.bear));
                        level.levelEvent(2001, blockpos, Block.getId((BlockState)blockstate));
                    }
                } else {
                    level.destroyBlock(blockpos, true, (Entity)this.bear);
                    level.levelEvent(2001, blockpos, Block.getId((BlockState)blockstate));
                }
                this.bear.eatCropAgainTicks = AbstractBearEntity.TICKS_TILL_HUNGRY_AGAIN;
            }
            this.canRaid = false;
            this.nextStartTick = 10;
        }
    }

    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        CropBlock cropBlock;
        Block block;
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.is(Blocks.FARMLAND) && this.wantsToRaid && !this.canRaid && (blockstate = level.getBlockState(pos.above())).is(this.bear.getFoodPreferences().forageTag()) && (!((block = blockstate.getBlock()) instanceof CropBlock) || (cropBlock = (CropBlock)block).isMaxAge(blockstate))) {
            this.canRaid = true;
            return true;
        }
        return false;
    }
}

