package com.startraveler.bearminimum;

import com.startraveler.bearminimum.entity.BlackBearEntity;
import com.startraveler.bearminimum.entity.BrownBearEntity;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1429;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_7225;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_83;
import net.minecraft.class_9169;
import java.util.function.Function;

public class BearMinimum implements ModInitializer {


    public static final class_1299<BlackBearEntity> BLACK_BEAR = class_2378.method_10230(
            class_7923.field_41177,
            Constants.id("black_bear"),
            class_1299.class_1300.method_5903(BlackBearEntity::new, class_1311.field_6294)
                    .method_17687(BlackBearEntity.WIDTH, BlackBearEntity.HEIGHT)
                    .method_27299(10)
                    .method_5905(class_5321.method_29179(class_7924.field_41266, Constants.id("black_bear")))
    );
    public static final class_1299<BrownBearEntity> BROWN_BEAR = class_2378.method_10230(
            class_7923.field_41177,
            Constants.id("brown_bear"),
            class_1299.class_1300.method_5903(BrownBearEntity::new, class_1311.field_6294)
                    .method_17687(BrownBearEntity.WIDTH, BrownBearEntity.HEIGHT)
                    .method_27299(10)
                    .method_5905(class_5321.method_29179(class_7924.field_41266, Constants.id("brown_bear")))
    );
    public static final class_1792 BEAR_MEAT = register(
            "bear_meat",
            class_1792::new,
            new class_1792.class_1793().method_19265(ModFoods.BEAR_MEAT)
    );
    public static final class_1792 BROWN_BEAR_SPAWN_EGG = register(
            "brown_bear_spawn_egg",
            class_1826::new,
            new class_1792.class_1793().method_72499(BROWN_BEAR)
    );
    public static final class_1792 BLACK_BEAR_SPAWN_EGG = register(
            "black_bear_spawn_egg",
            class_1826::new,
            new class_1792.class_1793().method_72499(BLACK_BEAR)
    );
    public static final class_1792 COOKED_BEAR_MEAT = register(
            "cooked_bear_meat",
            class_1792::new,
            new class_1792.class_1793().method_19265(ModFoods.COOKED_BEAR_MEAT)
    );
    private static final class_5321<class_52> POLAR_BEAR_LOOT_TABLE_ID = class_5321.method_29179(
            class_7924.field_50079,
            class_2960.method_60656("entities/polar_bear")
    );
    private static final class_5321<class_52> MODIFIED_POLAR_BEAR_LOOT_TABLE_ID = Constants.key(
            class_7924.field_50079,
            "entities/polar_bear"
    );

    public static class_1792 register(String name, Function<class_1792.class_1793, class_1792> itemFactory, class_1792.class_1793 settings) {
        // Create the item key.
        class_5321<class_1792> itemKey = Constants.key(class_7924.field_41197, name);

        // Create the item instance.
        class_1792 item = itemFactory.apply(settings.method_63686(itemKey));

        // Register the item.
        class_2378.method_39197(class_7923.field_41178, itemKey, item);

        return item;
    }

    @Override
    public void onInitialize() {

        // This method is invoked by the Fabric mod loader when it is ready
        // to load your mod. You can access Fabric and Common code in this
        // project.

        // Use Fabric to bootstrap the Common mod.
        // Constants.LOG.info("Hello Fabric world!");
        CommonClass.init();


        FabricDefaultAttributeRegistry.register(BLACK_BEAR, BlackBearEntity.method_26891());
        FabricDefaultAttributeRegistry.register(BROWN_BEAR, BrownBearEntity.method_26891());

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41061).register(entries -> {
            entries.method_45421(BEAR_MEAT);
            entries.method_45421(COOKED_BEAR_MEAT);
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(entries -> {
            entries.method_45421(BLACK_BEAR_SPAWN_EGG);
            entries.method_45421(BROWN_BEAR_SPAWN_EGG);
        });

        LootTableEvents.MODIFY.register((class_5321<class_52> id, class_52.class_53 builder, LootTableSource source, class_7225.class_7874 holderLookupProvider) -> {
            if (POLAR_BEAR_LOOT_TABLE_ID.equals(id)) {
                class_55 customPool = class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_351(class_83.method_428(MODIFIED_POLAR_BEAR_LOOT_TABLE_ID))
                        .method_355();
                builder.pool(customPool);
            }
        });

        BiomeModifications.addSpawn(
                BiomeSelectors.tag(BlackBearEntity.HAS_BLACK_BEAR_SPAWNS),
                class_1311.field_6294,
                BLACK_BEAR,
                10,
                1,
                4
        );

        class_1317.method_20637(
                BLACK_BEAR,
                class_9169.field_48745,
                class_2902.class_2903.field_13203,
                class_1429::method_20663
        );
        BiomeModifications.addSpawn(
                BiomeSelectors.tag(BrownBearEntity.HAS_BROWN_BEAR_SPAWNS),
                class_1311.field_6294,
                BROWN_BEAR,
                10,
                1,
                4
        );
        class_1317.method_20637(
                BROWN_BEAR,
                class_9169.field_48745,
                class_2902.class_2903.field_13203,
                class_1429::method_20663
        );
    }
}
