package com.startraveler.bearminimum.client.model;

import com.startraveler.bearminimum.Constants;
import net.minecraft.class_10057;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_597;
import net.minecraft.class_630;
import net.minecraft.class_9941;
import net.minecraft.class_9953;
import net.minecraft.client.model.geom.builders.*;
import java.util.Set;

public class BrownBearModel extends class_597<class_10057> {
    public static final class_5601 BODY_LAYER = new class_5601(Constants.id("brown_bear"), "main");
    public static final class_5601 BODY_LAYER_BABY = new class_5601(
            Constants.id("brown_bear_baby"),
            "main"
    );

    private static final float BABY_HEAD_SCALE = 2.25F;
    private static final class_9953 BABY_TRANSFORMER = new class_9941(
            true,
            16.0F,
            4.0F,
            BABY_HEAD_SCALE,
            2.0F,
            24.0F,
            Set.of("head")
    );


    public BrownBearModel(class_630 root) {
        super(root);
    }

    public static class_5607 createBodyLayer(boolean isBaby) {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();


        class_5610 head = partdefinition.method_32117(
                "head",
                class_5606.method_32108()
                        .method_32101(0, 0)
                        .method_32098(-4.5F, -5.0F, -7.0F, 9.0F, 8.0F, 9.0F, new class_5605(0.0F))
                        .method_32101(0, 56)
                        .method_32098(-2.5F, -2.0F, -11.0F, 5.0F, 4.0F, 4.0F, new class_5605(0.0F))
                        .method_32101(21, 61)
                        .method_32098(3.5F, -6.0F, -4.0F, 2.0F, 2.0F, 1.0F, new class_5605(0.0F))
                        .method_32101(21, 61)
                        .method_32098(-5.5F, -6.0F, -4.0F, 2.0F, 2.0F, 1.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.0F, 11.0F, -13.0F)
        );

        class_5610 body = partdefinition.method_32117(
                "body",
                class_5606.method_32108()
                        .method_32101(0, 30)
                        .method_32098(-5.0F, -13.0F, -7.0F, 14.0F, 14.0F, 11.0F, new class_5605(0.0F))
                        .method_32101(37, 0)
                        .method_32098(-4.0F, -25.0F, -7.0F, 12.0F, 12.0F, 12.0F, new class_5605(0.0F)),
                class_5603.method_32091(-2.0F, 9.0F, 12.0F, 1.5708F, 0.0F, 0.0F)
        );

        class_5610 rightHindLeg = partdefinition.method_32117(
                "right_hind_leg",
                class_5606.method_32108()
                        .method_32101(50, 30)
                        .method_32098(-2.0F, 0.0F, -2.0F, 4.0F, 10.0F, 8.0F, new class_5605(0.0F)),
                class_5603.method_32090(4.5F, 14.0F, 6.0F)
        );

        class_5610 leftHindLeg = partdefinition.method_32117(
                "left_hind_leg",
                class_5606.method_32108()
                        .method_32101(50, 30)
                        .method_32098(-2.0F, 0.0F, -2.0F, 4.0F, 10.0F, 8.0F, new class_5605(0.0F)),
                class_5603.method_32090(-4.5F, 14.0F, 6.0F)
        );

        class_5610 rightFrontLeg = partdefinition.method_32117(
                "right_front_leg",
                class_5606.method_32108()
                        .method_32101(50, 48)
                        .method_32098(-2.0F, 0.0F, -2.0F, 4.0F, 10.0F, 6.0F, new class_5605(0.0F)),
                class_5603.method_32090(3.5F, 14.0F, -8.0F)
        );

        class_5610 leftFrontLeg = partdefinition.method_32117(
                "left_front_leg",
                class_5606.method_32108()
                        .method_32101(50, 48)
                        .method_32098(-2.0F, 0.0F, -2.0F, 4.0F, 10.0F, 6.0F, new class_5605(0.0F)),
                class_5603.method_32090(-3.5F, 14.0F, -8.0F)
        );

        return class_5607.method_32110(meshdefinition, 128, 64)
                .method_62137(isBaby ? BABY_TRANSFORMER : class_9953.field_56092)
                .method_62137(class_9953.scaling(1.2F));
    }

    public void setupAnim(class_10057 renderState) {
        super.method_62089(renderState);
        float standScaleSquared = renderState.field_53550 * renderState.field_53550;
        float ageScale = renderState.field_53454;
        float headScale = renderState.field_53457 ? 0.44444445F : 1.0F;
        class_630 modelPart = this.field_3538;
        modelPart.field_3654 -= standScaleSquared * (float)Math.PI * 0.35F;
        modelPart = this.field_3538;
        modelPart.field_3656 += standScaleSquared * ageScale * 2.0F;
        modelPart = this.field_27478;
        modelPart.field_3656 -= standScaleSquared * ageScale * 20.0F;
        modelPart = this.field_27478;
        modelPart.field_3655 += standScaleSquared * ageScale * 4.0F;
        modelPart = this.field_27478;
        modelPart.field_3654 -= standScaleSquared * (float)Math.PI * 0.45F;
        this.field_27479.field_3656 = this.field_27478.field_3656;
        this.field_27479.field_3655 = this.field_27478.field_3655;
        modelPart = this.field_27479;
        modelPart.field_3654 -= standScaleSquared * (float)Math.PI * 0.45F;
        modelPart = this.field_3535;
        modelPart.field_3656 -= standScaleSquared * headScale * 24.0F; // was 24
        modelPart = this.field_3535;
        modelPart.field_3655 += standScaleSquared * headScale * 11.0F; // was 13
        modelPart = this.field_3535;
        modelPart.field_3654 += standScaleSquared * (float)Math.PI * 0.15F;
    }
}
