/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.bearminimum;

import com.startraveler.bearminimum.CommonClass;
import com.startraveler.bearminimum.Constants;
import com.startraveler.bearminimum.ModFoods;
import com.startraveler.bearminimum.client.model.BlackBearModel;
import com.startraveler.bearminimum.client.model.BrownBearModel;
import com.startraveler.bearminimum.client.renderer.BlackBearRenderer;
import com.startraveler.bearminimum.client.renderer.BrownBearRenderer;
import com.startraveler.bearminimum.entity.BlackBearEntity;
import com.startraveler.bearminimum.entity.BrownBearEntity;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="bearminimum")
public class BearMinimum {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"bearminimum");
    public static final DeferredHolder<EntityType<?>, EntityType<BlackBearEntity>> BLACK_BEAR = ENTITY_TYPES.register("black_bear", () -> EntityType.Builder.of(BlackBearEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.4f, 1.4f).clientTrackingRange(10).build(Constants.key(Registries.ENTITY_TYPE, "black_bear")));
    public static final DeferredHolder<EntityType<?>, EntityType<BrownBearEntity>> BROWN_BEAR = ENTITY_TYPES.register("brown_bear", () -> EntityType.Builder.of(BrownBearEntity::new, (MobCategory)MobCategory.CREATURE).sized(1.8f, 1.8f).clientTrackingRange(10).build(Constants.key(Registries.ENTITY_TYPE, "brown_bear")));
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"bearminimum");
    public static final DeferredHolder<Item, SpawnEggItem> BLACK_BEAR_SPAWN_EGG = ITEMS.register("black_bear_spawn_egg", () -> new SpawnEggItem(new Item.Properties().spawnEgg((EntityType)BLACK_BEAR.get()).setId(Constants.key(Registries.ITEM, "black_bear_spawn_egg"))));
    public static final DeferredHolder<Item, SpawnEggItem> BROWN_BEAR_SPAWN_EGG = ITEMS.register("brown_bear_spawn_egg", () -> new SpawnEggItem(new Item.Properties().spawnEgg((EntityType)BROWN_BEAR.get()).setId(Constants.key(Registries.ITEM, "brown_bear_spawn_egg"))));
    public static final DeferredHolder<Item, Item> BEAR_MEAT = ITEMS.register("bear_meat", () -> new Item(new Item.Properties().food(ModFoods.BEAR_MEAT).setId(Constants.key(Registries.ITEM, "bear_meat"))));
    public static final DeferredHolder<Item, Item> COOKED_BEAR_MEAT = ITEMS.register("cooked_bear_meat", () -> new Item(new Item.Properties().food(ModFoods.COOKED_BEAR_MEAT).setId(Constants.key(Registries.ITEM, "cooked_bear_meat"))));
    private static final ResourceLocation POLAR_BEAR_LOOT_TABLE_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entities/polar_bear");
    private static final ResourceKey<LootTable> MODIFIED_POLAR_BEAR_LOOT_TABLE_ID = Constants.key(Registries.LOOT_TABLE, "entities/polar_bear");

    public BearMinimum(ModContainer modContainer) {
        IEventBus modBus = modContainer.getEventBus();
        CommonClass.init();
        ITEMS.register(modBus);
        ENTITY_TYPES.register(modBus);
    }

    @EventBusSubscriber(modid="bearminimum")
    public static class NeoForgeEventBusEvents {
        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            ResourceLocation tableName = event.getName();
            if (tableName.equals((Object)POLAR_BEAR_LOOT_TABLE_ID)) {
                LootPool customPool = LootPool.lootPool().name("bearminimum_add_bear_drops").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(MODIFIED_POLAR_BEAR_LOOT_TABLE_ID)).build();
                event.getTable().addPool(customPool);
            }
        }
    }

    @EventBusSubscriber(modid="bearminimum")
    public static class ModEventBusEvents {
        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)BLACK_BEAR.get(), BlackBearEntity.createAttributes().build());
            event.put((EntityType)BROWN_BEAR.get(), BrownBearEntity.createAttributes().build());
        }

        @SubscribeEvent
        public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
            event.register((EntityType)BLACK_BEAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
            event.register((EntityType)BROWN_BEAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        }

        @SubscribeEvent
        public static void addCreative(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
                event.accept((ItemLike)BEAR_MEAT.get());
                event.accept((ItemLike)COOKED_BEAR_MEAT.get());
            }
            if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
                event.accept((ItemLike)BLACK_BEAR_SPAWN_EGG.get());
                event.accept((ItemLike)BROWN_BEAR_SPAWN_EGG.get());
            }
        }
    }

    @EventBusSubscriber(modid="bearminimum", value={Dist.CLIENT})
    public static class ClientModEventBusEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register((EntityType)((EntityType)BLACK_BEAR.get()), BlackBearRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)BROWN_BEAR.get()), BrownBearRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(BlackBearModel.BODY_LAYER, () -> BlackBearModel.createBodyLayer(false));
            event.registerLayerDefinition(BlackBearModel.BODY_LAYER_BABY, () -> BlackBearModel.createBodyLayer(true));
            event.registerLayerDefinition(BrownBearModel.BODY_LAYER, () -> BrownBearModel.createBodyLayer(false));
            event.registerLayerDefinition(BrownBearModel.BODY_LAYER_BABY, () -> BrownBearModel.createBodyLayer(true));
        }
    }
}

