/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.bearminimum.client.model;

import com.startraveler.bearminimum.Constants;
import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PolarBearRenderState;

public class BlackBearModel
extends QuadrupedModel<PolarBearRenderState> {
    public static final ModelLayerLocation BODY_LAYER = new ModelLayerLocation(Constants.id("black_bear"), "main");
    public static final ModelLayerLocation BODY_LAYER_BABY = new ModelLayerLocation(Constants.id("black_bear_baby"), "main");
    private static final float BABY_HEAD_SCALE = 2.25f;
    private static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(true, 16.0f, 4.0f, 2.25f, 2.0f, 24.0f, Set.of("head"));

    public BlackBearModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer(boolean isBaby) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(1, 0).addBox(-3.0f, -3.0f, -6.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(1, 44).addBox(-1.5f, 0.0f, -9.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(26, 0).addBox(2.0f, -4.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 0).addBox(-4.0f, -4.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)12.0f, (float)-11.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(4, 21).addBox(-3.5f, -12.0f, -7.0f, 11.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(40, 0).addBox(-3.5f, -23.0f, -7.0f, 11.0f, 11.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)10.0f, (float)12.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(52, 24).addBox(-3.0f, 0.0f, -2.0f, 4.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)16.0f, (float)5.0f));
        PartDefinition leftHindLeg = partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(52, 24).addBox(-1.0f, 0.0f, -2.0f, 4.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)16.0f, (float)5.0f));
        PartDefinition rightFrontLeg = partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(51, 41).addBox(-2.5f, 0.0f, -1.0f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)16.0f, (float)-7.0f));
        PartDefinition leftFrontLeg = partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(51, 41).addBox(-1.5f, 0.0f, -1.0f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)16.0f, (float)-7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64).apply(isBaby ? BABY_TRANSFORMER : MeshTransformer.IDENTITY).apply(MeshTransformer.scaling((float)1.2f));
    }

    public void setupAnim(PolarBearRenderState renderState) {
        super.setupAnim((LivingEntityRenderState)renderState);
        float standScaleSquared = renderState.standScale * renderState.standScale;
        float ageScale = renderState.ageScale;
        float headScale = renderState.isBaby ? 0.44444445f : 1.0f;
        ModelPart modelPart = this.body;
        modelPart.xRot -= standScaleSquared * (float)Math.PI * 0.35f;
        modelPart = this.body;
        modelPart.y += standScaleSquared * ageScale * 5.0f;
        modelPart = this.rightFrontLeg;
        modelPart.y -= standScaleSquared * ageScale * 17.0f;
        modelPart = this.rightFrontLeg;
        modelPart.z += standScaleSquared * ageScale * 4.0f;
        modelPart = this.rightFrontLeg;
        modelPart.xRot -= standScaleSquared * (float)Math.PI * 0.45f;
        this.leftFrontLeg.y = this.rightFrontLeg.y;
        this.leftFrontLeg.z = this.rightFrontLeg.z;
        modelPart = this.leftFrontLeg;
        modelPart.xRot -= standScaleSquared * (float)Math.PI * 0.45f;
        modelPart = this.head;
        modelPart.y -= standScaleSquared * headScale * 18.0f;
        modelPart = this.head;
        modelPart.z += standScaleSquared * headScale * 9.0f;
        modelPart = this.head;
        modelPart.xRot += standScaleSquared * (float)Math.PI * 0.15f;
    }
}

