package com.startraveler.bearminimum.entity.goal;

import com.startraveler.bearminimum.entity.AbstractBearEntity;
import com.startraveler.bearminimum.mixin.CropBlockMixin;
import net.minecraft.class_1367;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_6088;

public class ForageGoal extends class_1367 {
    public static final int TICKS_TILL_START_AGAIN = 10;
    private final AbstractBearEntity bear;
    private boolean wantsToRaid;
    private boolean canRaid;

    public ForageGoal(AbstractBearEntity bear) {
        super(bear, 0.7F, 16);
        this.bear = bear;
    }

    @Override
    public boolean method_6264() {
        if (this.field_6518 <= 0) {
            if (!method_64451(this.bear).method_64395().method_8355(class_1928.field_19388)) {
                return false;
            }

            this.canRaid = false;
            this.wantsToRaid = this.bear.wantsMoreFood();
        }
        return super.method_6264();
    }

    @Override
    public boolean method_6266() {
        return this.canRaid && super.method_6266();
    }

    public void method_6268() {
        super.method_6268();
        this.bear.method_5988().method_6230(
                this.field_6512.method_10263() + 0.5,
                this.field_6512.method_10264() + 1,
                this.field_6512.method_10260() + 0.5,
                10.0F,
                this.bear.method_5978()
        );
        if (this.method_6295()) {
            class_1937 level = this.bear.method_37908();
            class_2338 blockpos = this.field_6512.method_10084();
            class_2680 blockstate = level.method_8320(blockpos);
            class_2248 block = blockstate.method_26204();
            if (this.canRaid && blockstate.method_26164(this.bear.getFoodPreferences().forageTag())) {
                if (block instanceof class_2302 cropBlock) {
                    class_2758 property = ((CropBlockMixin) cropBlock).invokeGetAgeProperty();
                    int age = blockstate.method_11654(property);
                    int minAge = property.method_11898().stream().mapToInt(a -> a).min().orElse(0);
                    if (age == minAge) {
                        level.method_8652(blockpos, class_2246.field_10124.method_9564(), class_2248.field_31028);
                        level.method_8651(blockpos, true, this.bear);
                    } else {
                        level.method_8652(blockpos, blockstate.method_11657(property, minAge), class_2248.field_31028);
                        level.method_43276(class_5712.field_28733, blockpos, class_5712.class_7397.method_43285(this.bear));
                        level.method_20290(class_6088.field_31144, blockpos, class_2248.method_9507(blockstate));
                    }

                } else {
                    level.method_8651(blockpos, true, this.bear);
                    level.method_20290(class_6088.field_31144, blockpos, class_2248.method_9507(blockstate));
                }

                this.bear.eatCropAgainTicks = AbstractBearEntity.TICKS_TILL_HUNGRY_AGAIN;
            }

            this.canRaid = false;
            this.field_6518 = TICKS_TILL_START_AGAIN;
        }

    }

    @Override
    protected boolean method_6296(class_4538 level, class_2338 pos) {
        class_2680 blockstate = level.method_8320(pos);
        if (blockstate.method_27852(class_2246.field_10362) && this.wantsToRaid && !this.canRaid) {
            blockstate = level.method_8320(pos.method_10084());
            if (blockstate.method_26164(this.bear.getFoodPreferences()
                    .forageTag()) && (!(blockstate.method_26204() instanceof class_2302 cropBlock) || cropBlock.method_9825(
                    blockstate))) {
                this.canRaid = true;
                return true;
            }
        }

        return false;
    }
}
