package com.startraveler.bearminimum.entity;


import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1456;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public abstract class AbstractBearEntity extends class_1456 {

    public static final float SCARED_BOOST = 1.5f;
    public static final Integer TICKS_TILL_HUNGRY_AGAIN = 40;
    public static final String EAT_CROP_AGAIN_TICKS_ID = "EatCropsAgainTicks";
    public final BearFoodPreferences foodPreferences;
    public int eatCropAgainTicks = 0;

    public AbstractBearEntity(class_1299<? extends AbstractBearEntity> entityType, class_1937 level, BearFoodPreferences foodPreferences) {
        super(entityType, level);
        this.foodPreferences = foodPreferences;

    }

    @Override
    public boolean method_5931() {
        return !this.method_29511();
    }

    @Override
    public boolean method_5874(class_3218 level, class_1309 entity) {
        this.eatCropAgainTicks = TICKS_TILL_HUNGRY_AGAIN * 20;
        return super.method_5874(level, entity);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(this.foodPreferences.foodTag());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.eatCropAgainTicks = 0;
        if (compound.method_10545(EAT_CROP_AGAIN_TICKS_ID)) {

            this.eatCropAgainTicks = compound.method_10550(EAT_CROP_AGAIN_TICKS_ID);
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569(EAT_CROP_AGAIN_TICKS_ID, this.eatCropAgainTicks);
    }

    @Override
    public void method_6602() {
        super.method_6602();
    }

    @Override
    public void method_5958(class_3218 level) {
        super.method_5958(level);

        if (this.eatCropAgainTicks > 0) {
            this.eatCropAgainTicks -= this.field_5974.method_43048(3);
            if (this.eatCropAgainTicks < 0) {
                this.eatCropAgainTicks = 0;
            }
        }
    }

    public boolean wantsMoreFood() {
        return this.eatCropAgainTicks <= 0;
    }

}
