/*
 * Decompiled with CFR 0.152.
 */
package com.apotheosisbalancer;

import com.apotheosisbalancer.ApotheosisBalancer;
import com.apotheosisbalancer.util.RarityContext;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="apotheosisbalancer", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BalancerConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.DoubleValue APOTHEOSIS_MULTIPLIER = BUILDER.comment(new String[]{"Multiplier for base Apotheosis values (gems, affixes, effects, etc.)", "Examples:", "  1.0 = default values (no change)", "  0.5 = reduce all values by 50%", "  2.0 = double all values", "This affects ONLY base Apotheosis content:", "  - Gem attribute bonuses (attack speed, damage, armor, etc.)", "  - Affix attribute values", "  - Durability bonuses", "  - Potion effect durations and amplifiers", "  - All other numerical bonuses from BASE Apotheosis", "Changes require game restart to take effect."}).defineInRange("apotheosisMultiplier", 1.0, 0.0, 100.0);
    public static final ForgeConfigSpec.DoubleValue ADDITIONS_MULTIPLIER = BUILDER.comment(new String[]{"Multiplier for ApotheoticAdditions values", "This is separate from base Apotheosis multiplier!", "ApotheoticAdditions adds new rarities: Relic, Heirloom, Esoteric", "and many new gems and affixes with higher values.", "Examples:", "  1.0 = default values", "  0.7 = reduce by 30% (recommended for balance)", "  0.5 = reduce by 50%", "This affects ONLY ApotheoticAdditions content.", "Changes require game restart to take effect."}).defineInRange("additionsMultiplier", 1.0, 0.0, 100.0);
    public static final ForgeConfigSpec.DoubleValue FALLBACK_MULTIPLIER = BUILDER.comment(new String[]{"Fallback multiplier used when mod detection fails", "This is used for any StepFunction calls that can't be traced", "to either Apotheosis or ApotheoticAdditions.", "Usually you want this to match apotheosisMultiplier."}).defineInRange("fallbackMultiplier", 1.0, 0.0, 100.0);
    public static final ForgeConfigSpec.DoubleValue QUALITY_MULTIPLIER = BUILDER.comment(new String[]{"Multiplier for quality values in affix loot entries", "Quality affects:", "  1. Luck-based selection (higher quality = more likely with luck)", "  2. Number of affixes that can roll on items", "Examples:", "  1.0 = no change (default)", "  0.5 = reduce quality by 50% (fewer affixes, less luck impact)", "  0.7 = reduce quality by 30%", "This is VERY useful for balance - lower quality = simpler items with fewer affixes!", "Changes require game restart to take effect."}).defineInRange("qualityMultiplier", 1.0, 0.0, 100.0);
    public static final ForgeConfigSpec.IntValue MIN_RARITY_OFFSET = BUILDER.comment(new String[]{"Shift min_rarity for all affix loot entries (weapons, armor, etc.)", "Positive values increase minimum rarity, negative values decrease it.", "Examples:", "  0 = no change (default)", "  -1 = decrease by one rarity level (rare \u2192 uncommon)", "  -2 = decrease by two levels (mythic \u2192 rare)", "  +1 = increase by one level (common \u2192 uncommon)", "Clamped to valid rarity range (won't go below common or above ancient).", "Changes require game restart to take effect."}).defineInRange("minRarityOffset", 0, -10, 10);
    public static final ForgeConfigSpec.IntValue MAX_RARITY_OFFSET = BUILDER.comment(new String[]{"Shift max_rarity for all affix loot entries (weapons, armor, etc.)", "Positive values increase maximum rarity, negative values decrease it.", "Examples:", "  0 = no change (default)", "  -1 = decrease by one rarity level (mythic \u2192 epic)", "  -2 = decrease by two levels (mythic \u2192 rare)", "  +1 = increase by one level (rare \u2192 epic)", "Clamped to valid rarity range.", "Changes require game restart to take effect."}).defineInRange("maxRarityOffset", 0, -10, 10);
    public static final ForgeConfigSpec.BooleanValue ENABLE_ATTRIBUTE_BALANCE = BUILDER.comment("Enable balancing for attribute bonuses (attack speed, damage, armor, etc.)").define("enableAttributeBalance", true);
    public static final ForgeConfigSpec.BooleanValue ENABLE_ENCHANTMENT_BALANCE = BUILDER.comment("Enable balancing for enchantment level bonuses from gems").define("enableEnchantmentBalance", true);
    public static final ForgeConfigSpec.BooleanValue ENABLE_POTION_BALANCE = BUILDER.comment("Enable balancing for potion effect bonuses (duration, amplifier, cooldown)").define("enablePotionBalance", true);
    public static final ForgeConfigSpec.BooleanValue ENABLE_SPECIAL_BALANCE = BUILDER.comment("Enable balancing for special bonuses (bloody_arrow, leech_block, etc.)").define("enableSpecialBalance", true);
    public static final ForgeConfigSpec.EnumValue<RoundingMode> ENCHANTMENT_ROUNDING = BUILDER.comment(new String[]{"Rounding mode for enchantment levels:", "  STANDARD - Math.round() standard rounding (1.5 -> 2, 1.4 -> 1)", "  CEIL_IF_ABOVE_ONE - If result > 1.0, round up to at least 2 (1.05 -> 2)", "  ALWAYS_CEIL - Always round up (1.1 -> 2)", "  ALWAYS_FLOOR - Always round down (1.9 -> 1)"}).defineEnum("enchantmentRounding", (Enum)RoundingMode.ALWAYS_CEIL);
    public static final ForgeConfigSpec.EnumValue<RoundingMode> POTION_ROUNDING = BUILDER.comment(new String[]{"Rounding mode for potion effect amplifiers (levels):", "  STANDARD - Math.round() standard rounding", "  CEIL_IF_ABOVE_ONE - If result > 1.0, round up to at least 2", "  ALWAYS_CEIL - Always round up", "  ALWAYS_FLOOR - Always round down"}).defineEnum("potionRounding", (Enum)RoundingMode.ALWAYS_CEIL);
    public static final ForgeConfigSpec.BooleanValue ENABLE_DEBUG_LOGGING = BUILDER.comment(new String[]{"Enable debug logging to see when values are being multiplied", "Shows which multiplier is being applied and from which mod.", "WARNING: Creates a LOT of log messages!"}).define("enableDebugLogging", false);
    public static final ForgeConfigSpec.BooleanValue SHOW_CALLER_INFO = BUILDER.comment(new String[]{"Show detailed caller information in debug logs", "Includes full stack trace analysis.", "Only works if enableDebugLogging is true."}).define("showCallerInfo", false);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static double apotheosisMultiplier;
    public static double additionsMultiplier;
    public static double fallbackMultiplier;
    public static double qualityMultiplier;
    public static int minRarityOffset;
    public static int maxRarityOffset;
    public static boolean enableAttributeBalance;
    public static boolean enableEnchantmentBalance;
    public static boolean enablePotionBalance;
    public static boolean enableSpecialBalance;
    public static RoundingMode enchantmentRounding;
    public static RoundingMode potionRounding;
    public static boolean enableDebugLogging;
    public static boolean showCallerInfo;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        apotheosisMultiplier = (Double)APOTHEOSIS_MULTIPLIER.get();
        additionsMultiplier = (Double)ADDITIONS_MULTIPLIER.get();
        fallbackMultiplier = (Double)FALLBACK_MULTIPLIER.get();
        qualityMultiplier = (Double)QUALITY_MULTIPLIER.get();
        minRarityOffset = (Integer)MIN_RARITY_OFFSET.get();
        maxRarityOffset = (Integer)MAX_RARITY_OFFSET.get();
        enableAttributeBalance = (Boolean)ENABLE_ATTRIBUTE_BALANCE.get();
        enableEnchantmentBalance = (Boolean)ENABLE_ENCHANTMENT_BALANCE.get();
        enablePotionBalance = (Boolean)ENABLE_POTION_BALANCE.get();
        enableSpecialBalance = (Boolean)ENABLE_SPECIAL_BALANCE.get();
        enchantmentRounding = (RoundingMode)((Object)ENCHANTMENT_ROUNDING.get());
        potionRounding = (RoundingMode)((Object)POTION_ROUNDING.get());
        enableDebugLogging = (Boolean)ENABLE_DEBUG_LOGGING.get();
        showCallerInfo = (Boolean)SHOW_CALLER_INFO.get();
        ApotheosisBalancer.LOGGER.info("========================================");
        ApotheosisBalancer.LOGGER.info("Apotheosis Balancer config loaded:");
        ApotheosisBalancer.LOGGER.info("  Apotheosis multiplier:    {}", (Object)apotheosisMultiplier);
        ApotheosisBalancer.LOGGER.info("  Additions multiplier:     {}", (Object)additionsMultiplier);
        ApotheosisBalancer.LOGGER.info("  Fallback multiplier:      {}", (Object)fallbackMultiplier);
        ApotheosisBalancer.LOGGER.info("  Quality multiplier:       {}", (Object)qualityMultiplier);
        ApotheosisBalancer.LOGGER.info("  Min rarity offset:        {}", (Object)minRarityOffset);
        ApotheosisBalancer.LOGGER.info("  Max rarity offset:        {}", (Object)maxRarityOffset);
        ApotheosisBalancer.LOGGER.info("  Debug logging:            {}", (Object)enableDebugLogging);
        ApotheosisBalancer.LOGGER.info("  Show caller info:         {}", (Object)showCallerInfo);
        ApotheosisBalancer.LOGGER.info("========================================");
    }

    public static double getMultiplierForContext() {
        StackTraceElement[] stackTrace;
        try {
            if (RarityContext.isApotheoticAdditions()) {
                if (enableDebugLogging && showCallerInfo) {
                    ApotheosisBalancer.LOGGER.debug("Detected ApotheoticAdditions rarity: {}", (Object)RarityContext.getRarityId());
                }
                return additionsMultiplier;
            }
            if (RarityContext.isBaseApotheosis()) {
                if (enableDebugLogging && showCallerInfo) {
                    ApotheosisBalancer.LOGGER.debug("Detected Apotheosis rarity: {}", (Object)RarityContext.getRarityId());
                }
                return apotheosisMultiplier;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (!className.contains("apotheosis") || className.contains("apotheosisbalancer")) continue;
            if (enableDebugLogging && showCallerInfo) {
                ApotheosisBalancer.LOGGER.debug("Detected Apotheosis call from stack trace: {}", (Object)className);
            }
            return apotheosisMultiplier;
        }
        if (enableDebugLogging && showCallerInfo) {
            ApotheosisBalancer.LOGGER.debug("Using fallback multiplier (no context detected)");
        }
        return fallbackMultiplier;
    }

    public static DynamicHolder<LootRarity> shiftRarity(DynamicHolder<LootRarity> holder, int offset) {
        if (offset == 0 || !holder.isBound()) {
            return holder;
        }
        try {
            DynamicHolder current = holder;
            String originalNamespace = current.getId().m_135827_();
            if (offset > 0) {
                DynamicHolder next;
                for (int i = 0; i < offset && (next = RarityRegistry.next(current)) != current; ++i) {
                    String nextNamespace = next.getId().m_135827_();
                    if (!nextNamespace.equals(originalNamespace)) {
                        if (!enableDebugLogging) break;
                        ApotheosisBalancer.LOGGER.debug("Rarity shift stopped at namespace boundary: {} (can't cross to {})", (Object)current.getId(), (Object)next.getId());
                        break;
                    }
                    current = next;
                }
            } else {
                DynamicHolder prev;
                for (int i = 0; i < Math.abs(offset) && (prev = RarityRegistry.prev(current)) != current; ++i) {
                    String prevNamespace = prev.getId().m_135827_();
                    if (!prevNamespace.equals(originalNamespace)) {
                        if (!enableDebugLogging) break;
                        ApotheosisBalancer.LOGGER.debug("Rarity shift stopped at namespace boundary: {} (can't cross to {})", (Object)current.getId(), (Object)prev.getId());
                        break;
                    }
                    current = prev;
                }
            }
            return current;
        }
        catch (Exception e) {
            ApotheosisBalancer.LOGGER.error("Failed to shift rarity: ", (Throwable)e);
            return holder;
        }
    }

    public static int applyRounding(float value, RoundingMode mode) {
        return BalancerConfig.applyRoundingInternal(value, mode, 1);
    }

    public static int applyRoundingForPotions(float value, RoundingMode mode) {
        return BalancerConfig.applyRoundingInternal(value, mode, 0);
    }

    private static int applyRoundingInternal(float value, RoundingMode mode, int minValue) {
        switch (mode) {
            case STANDARD: {
                return Math.max(minValue, Math.round(value));
            }
            case CEIL_IF_ABOVE_ONE: {
                if (value >= 1.0f) {
                    return Math.max(2, (int)Math.ceil(value));
                }
                return Math.max(minValue, Math.round(value));
            }
            case ALWAYS_CEIL: {
                return Math.max(minValue, (int)Math.ceil(value));
            }
            case ALWAYS_FLOOR: {
                return Math.max(minValue, (int)Math.floor(value));
            }
        }
        return Math.max(minValue, Math.round(value));
    }

    public static enum RoundingMode {
        STANDARD,
        CEIL_IF_ABOVE_ONE,
        ALWAYS_CEIL,
        ALWAYS_FLOOR;

    }
}

